<?php
namespace TotalThemeCore\WPBakery;

defined( 'ABSPATH' ) || exit;

/**
 * WPBakery tweaks and custom shortcodes.
 *
 * @package TotalThemeCore
 * @version 1.5.1
 */
final class Init {

	/**
	 * Instance.
	 */
	private static $instance;

	/**
	 * Create or retrieve the instance of Init.
	 */
	public static function instance() {
		if ( is_null( static::$instance ) ) {
			static::$instance = new self();
			static::$instance->initiate_classes();
			static::$instance->init_hooks();
		}

		return static::$instance;
	}

	/**
	 * Hook into actions and filters.
	 */
	public function init_hooks() {
		// Global functions.
		add_action( 'vc_before_mapping', [ $this, 'vc_before_mapping' ] );
		add_action( 'vc_load_default_params', [ $this, 'load_params' ] );

		// Register scripts.
		add_action( 'vc_base_register_admin_css', [ $this, 'register_editor_css' ] );
		add_action( 'vc_base_register_front_css', [ $this, 'register_editor_css' ] );

		// Enqueue scripts.
		add_action( 'vc_load_iframe_jscss', [ $this, 'editor_iframe_scripts' ], PHP_INT_MAX );
		add_action( 'vc_backend_editor_enqueue_js_css', [ $this, 'backend_editor_scripts' ] );
		add_action( 'vc_frontend_editor_enqueue_js_css', [ $this, 'frontend_editor_scripts' ] );
		add_action( 'vc_page_settings_build', [ $this, 'settings_scripts'] );
	}

	/**
	 * Initiate classes.
	 */
	public function initiate_classes() {
		if ( is_admin() || ( function_exists( 'vc_is_inline' ) && vc_is_inline() ) ) {
			new Templatera\Enable_Frontend;
		}
	}

	/**
	 * Run functions before/needed for VC mapping.
	 */
	public function vc_before_mapping() {
		add_filter(
			'vc_iconpicker-type-ticons',
			'TotalThemeCore\\WPBakery\\Iconpicker\Ticons::get_icons'
		);
	}

	/**
	 * Registers custom params.
	 */
	public function load_params() {
		if ( function_exists( 'vc_add_shortcode_param' ) ) {
			require_once TTC_PLUGIN_DIR_PATH . 'inc/wpbakery/add-params.php';
		}
	}

	/**
	 * Register CSS scripts.
	 */
	public function register_editor_css() {
		wp_register_style(
			'vcex-wpbakery-editor',
			TTC_PLUGIN_DIR_URL . 'inc/wpbakery/assets/css/vcex-wpbakery-editor.css',
			[],
			TTC_VERSION
		);
	}

	/**
	 * Register JS Scripts.
	 */
	public function register_frontend_js() {
		wp_register_script(
			'vcex-vc_reload',
			TTC_PLUGIN_DIR_URL . 'inc/wpbakery/assets/js/frontend-editor/vcex-vc_reload.min.js',
			[ 'jquery' ],
			TTC_VERSION,
			true
		);
	}

	/**
	 * Editor Scripts.
	 */
	public function editor_iframe_scripts() {
		wp_enqueue_style(
			'vcex-wpbakery-vc-helper',
			TTC_PLUGIN_DIR_URL . 'inc/wpbakery/assets/css/vc-helper.css',
			[],
			TTC_VERSION
		);
		wp_enqueue_script(
			'vcex-vc_reload',
			TTC_PLUGIN_DIR_URL . 'inc/wpbakery/assets/js/frontend-editor/vcex-vc_reload.min.js',
			[ 'jquery' ],
			TTC_VERSION,
			true
		);
	}

	/**
	 * Enqueue backend editor scripts.
	 *
	 * @todo move vcex-params.min.js here if possible? Not sure if it's any better.
	 */
	public function backend_editor_scripts() {
		wp_enqueue_style( 'vcex-wpbakery-editor' );
	}

	/**
	 * Enqueue frontend editor scripts.
	 */
	public function frontend_editor_scripts() {
		wp_enqueue_style( 'vcex-wpbakery-editor' );
	}

	/**
	 * Enqueue scripts for the WPBakery settings pages.
	 */
	public function settings_scripts() {
		wp_enqueue_style(
			'vcex-element-icons',
			TTC_PLUGIN_DIR_URL . 'inc/wpbakery/assets/css/vcex-element-icons.css',
			[ 'js_composer_settings' ],
			TTC_VERSION
		);
	}

}