<?php
namespace TotalThemeCore\WPBakery\Autocomplete;

defined( 'ABSPATH' ) || exit;

/**
 * WPBakery AutoComplete => Woocommerce Categories.
 *
 * @package TotalThemeCore
 * @version 1.4.9
 */
final class Woo_Categories {

	public static function callback( $search_string ) {
		$product_categories = [];
		$get_terms = get_terms( 'product_cat', [
			'hide_empty' => false,
			'search'     => $search_string,
		] );
		if ( $get_terms && ! is_wp_error( $get_terms ) ) {
			foreach ( $get_terms as $term ) {
				if ( $term->parent ) {
					$parent = get_term( $term->parent, 'product_cat' );
					$label = $term->name .' ('. $parent->name .')';
				} else {
					$label = $term->name;
				}
				$product_categories[] = [
					'label' => $label,
					'value' => $term->term_id,
				];
			}
		}
		return $product_categories;
	}

	public static function render( $data ) {
		$value = $data['value'];
		$term = get_term_by( 'term_id', intval( $value ), 'product_cat' );
		if ( is_object( $term ) ) {
			if ( $term->parent ) {
				$parent = get_term( $term->parent, 'product_cat' );
				$label = $term->name .' ('. $parent->name .')';
			} else {
				$label = $term->name;
			}
			return array(
				'label' => $label,
				'value' => $value,
			);
		}
		return $data;
	}

}