<?php
/**
 * Register Custom WPBakery Shortcode Parameters.
 *
 * @package TotalThemeCore
 * @version 1.5.1
 */

defined( 'ABSPATH' ) || exit;

$js = TTC_PLUGIN_DIR_URL . 'inc/wpbakery/assets/js/params/vcex-params.min.js?v=' . TTC_VERSION;

$namespace = 'TotalThemeCore\\WPBakery\\Params\\';

vc_add_shortcode_param( 'vcex_text', $namespace . 'Text::output' );
vc_add_shortcode_param( 'vcex_colorpicker', $namespace . 'Colorpicker::output' );
vc_add_shortcode_param( 'vcex_subheading', $namespace . 'Subheading::output' );
vc_add_shortcode_param( 'vcex_attach_images', $namespace . 'Attach_Images::output' );
vc_add_shortcode_param( 'vcex_sorter', $namespace . 'Sorter::output', $js );
vc_add_shortcode_param( 'vcex_button_colors', $namespace . 'Button_Colors::output', $js );
vc_add_shortcode_param( 'vcex_button_styles', $namespace . 'Button_Styles::output' );
vc_add_shortcode_param( 'vcex_font_family_select', $namespace . 'Font_Family::output', $js );
vc_add_shortcode_param( 'vcex_font_size', $namespace . 'Font_Size::output', $js );
vc_add_shortcode_param( 'vcex_grid_columns', $namespace . 'Grid_Column::output' );
vc_add_shortcode_param( 'vcex_column_gaps', $namespace . 'Grid_Column_Gap::output' );
vc_add_shortcode_param( 'vcex_grid_columns_responsive', $namespace . 'Grid_Column_Responsive::output', $js );
vc_add_shortcode_param( 'vcex_hover_animations', $namespace . 'Hover_Animation::output' );
vc_add_shortcode_param( 'vcex_image_crop_locations', $namespace . 'Image_Crop_Location::output' );
vc_add_shortcode_param( 'vcex_image_sizes', $namespace . 'Image_Size::output' );
vc_add_shortcode_param( 'vcex_menus_select', $namespace . 'Menu::output' );
vc_add_shortcode_param( 'vcex_notice', $namespace . 'Notice::output' );
vc_add_shortcode_param( 'vcex_number', $namespace . 'Number::output' );
vc_add_shortcode_param( 'vcex_ofswitch', $namespace . 'On_Off_Switch::output', $js );
vc_add_shortcode_param( 'vcex_orderby', $namespace . 'Query_Orderby::output' );
vc_add_shortcode_param( 'vcex_responsive_sizes', $namespace . 'Responsive_Input::output', $js );
vc_add_shortcode_param( 'vcex_select_buttons', $namespace . 'Select_Buttons::output', $js );
vc_add_shortcode_param( 'vcex_social_button_styles', $namespace . 'Select_Social_Button_Style::output' );
vc_add_shortcode_param( 'vcex_text_alignments', $namespace . 'Text_Align::output' );
vc_add_shortcode_param( 'vcex_trbl', $namespace . 'Top_Right_Bottom_Left::output', $js );
vc_add_shortcode_param( 'vcex_template_select', $namespace . 'Select_Template::output' );
vc_add_shortcode_param( 'vcex_preset_textfield', $namespace . 'Preset_Textfield::output', $js );
vc_add_shortcode_param( 'vcex_min_max', $namespace . 'Min_Max::output', $js );
vc_add_shortcode_param( 'vcex_select', $namespace . 'Select::output' );
vc_add_shortcode_param( 'vcex_custom_field', $namespace . 'Custom_Field::output' );

// vc_add_shortcode_param( 'vcex_icon_select', $namespace . 'Icon_Select::output' ); // @todo add theme Icon Select and replace old Icon select function.

if ( get_theme_mod( 'cards_enable', true ) ) {
	vc_add_shortcode_param( 'vcex_wpex_card_select', $namespace . 'Select_Card_Style::output' );
}

if ( defined( 'WPCF7_VERSION' ) ) {
	vc_add_shortcode_param( 'vcex_cf7_select', $namespace . 'Cf7_Select::output' );
}