<?php
namespace TotalThemeCore\Vcex\WPBakery\Views\Backend\Image;

defined( 'ABSPATH' ) || exit;

/**
 * Custom view for displaying images in the WPBakery backend editor.
 *
 * @package TotalThemeCore
 * @version 1.5.1
 */
final class View {

	/**
	 * Instance.
	 */
	private static $instance;

	/**
	 * Create or retrieve the instance of Image.
	 */
	public static function instance() {
		if ( is_null( static::$instance ) ) {
			static::$instance = new self();
			static::$instance->register_actions();
		}
		return static::$instance;
	}

	/**
	 * Constructor.
	 */
	public function register_actions() {
		add_action( 'wp_ajax_vcex_wpbakery_backend_view_image', [ $this, 'generate' ] );
	}

	/**
	 * AJAX callback.
	 */
	public function generate() {
		if ( ! function_exists( 'vc_user_access' ) ) {
			wp_die();
		}

		vc_user_access()->checkAdminNonce()->validateDie()->wpAny( 'edit_posts', 'edit_pages' )->validateDie();

		$content = vc_post_param( 'content' );
		$post_id = (int) vc_post_param( 'post_id' );
		$source  = vc_post_param( 'image_source', 'media_library' );
		$img     = '';

		switch ( $source ) {
			case 'media_library':
			case 'featured':
				if ( 'featured' === $source ) {
					if ( $post_id && has_post_thumbnail( $post_id ) && 'templatera' != get_post_type( $post_id ) ) {
						$img_id = get_post_thumbnail_id( $post_id );
					} else {
						$img_id = 0;
					}
				} else {
					$img_id = preg_replace( '/[^\d]/', '', intval( $content ) );
				}
				if ( $img_id ) {
					$img = wp_get_attachment_image_url( $img_id, 'thumbnail' );
				}
				break;
			case 'author_avatar';
				$img = get_avatar_url( get_post_field( 'post_author', $post_id ), array( 'size' => get_option( 'thumbnail_size_w' ) ) );

				break;
			case 'user_avatar';
				$img = get_avatar_url( wp_get_current_user(), array( 'size' => get_option( 'thumbnail_size_w' ) ) );
				break;
			case 'external';
				if ( $content ) {
					$img = $content;
				}
				break;
			case 'custom_field';
				if ( $content ) {
					if ( str_starts_with( $content , 'field_' ) && function_exists( 'get_field' ) ) {
						$img = vcex_acf_utils()->get_field_image_id( $content, $post_id );
					} else {
						$img = get_post_meta( $post_id, $content, true );
					}
					if ( is_numeric( $img ) ) {
						$img = wp_get_attachment_image_url( $img, 'thumbnail' );
					}
				}
				break;
			case 'secondary_thumbnail':
				$secondary_thumbnail = get_post_meta( $post_id, 'wpex_secondary_thumbnail', true );
				if ( $secondary_thumbnail ) {
					if ( is_numeric( $secondary_thumbnail ) ) {
						$img = wp_get_attachment_image_url( $secondary_thumbnail, 'thumbnail' );
					} elseif ( is_string( $secondary_thumbnail ) ) {
						$img = $secondary_thumbnail;
					}
				}
				break;
		}
		if ( $img ) {
			echo esc_url( $img );
		}
		wp_die();
	}

}