<?php
namespace TotalThemeCore\Vcex\WPBakery\Views\Backend\Custom_Field;

defined( 'ABSPATH' ) || exit;

/**
 * Custom view for displaying custom field in the WPBakery backend editor.
 *
 * @package TotalThemeCore
 * @version 1.5.1
 */
final class View {

	/**
	 * Instance.
	 */
	private static $instance;

	/**
	 * Create or retrieve the instance of Image.
	 */
	public static function instance() {
		if ( is_null( static::$instance ) ) {
			static::$instance = new self();
			static::$instance->register_actions();
		}
		return static::$instance;
	}

	/**
	 * Register actions.
	 */
	public function register_actions() {
		add_action( 'wp_ajax_vcex_wpbakery_backend_view_custom_field', [ $this, 'ajax_callback' ] );
	}

	/**
	 * AJAX callback.
	 */
	public function ajax_callback() {
		if ( ! function_exists( 'vc_user_access' ) ) {
			wp_die();
		}

		vc_user_access()->checkAdminNonce()->validateDie()->wpAny( 'edit_posts', 'edit_pages' )->validateDie();

		$field_name = vc_post_param( 'field_name' );

		if ( function_exists( 'get_field_object' ) && str_starts_with( $field_name, 'field_' ) ) {
			$field_obj = get_field_object( $field_name );
			if ( is_array( $field_obj ) && ! empty( $field_obj['label'] ) ) {
				$field_name = $field_obj['label'];
			}
		}

		echo sanitize_text_field( $field_name );

		wp_die();
	}

}