<?php
namespace TotalThemeCore\Vcex\WPBakery\Map;

use VCEX_WooCommerce_Template_Shortcode as Shortcode;

use TotalThemeCore\Vcex\WPBakery\Shortcode_Params;
use TotalThemeCore\Vcex\WPBakery\Helpers as WPBakery_Helpers;

defined( 'ABSPATH' ) || exit;

/**
 * Register shortcode with the WPBakery page builder.
 *
 * @package TotalThemeCore
 * @version 1.5.1
 */
final class WooCommerce_Template {

	/**
	 * Constructor.
	 */
	public function __construct() {
		add_action( 'vc_after_mapping', [ $this, 'vc_after_mapping' ] );
	}

	/**
	 * Run functions on vc_after_mapping hook.
	 */
	public function vc_after_mapping() {
		vc_lean_map( Shortcode::TAG, [ $this, 'map' ] );
	}

	/**
	 * Map shortcode via vc_lean_map.
	 */
	public function map() {
		$category = [ 'WooCommerce' ];
		$branding = vcex_shortcodes_branding();
		if ( $branding ) {
			$category[] = $branding;
		}
		return [
			'name'             => Shortcode::get_title(),
			'description'      => Shortcode::get_description(),
			'base'             => Shortcode::TAG,
			'icon'             => 'vcex_element-icon vcex_element-icon--woocommerce',
			'category'         => $category,
			'params'           => Shortcode_Params::get( 'VCEX_WooCommerce_Template_Shortcode' ),
			'js_view'          => 'vcexWooTemplateView',
			'admin_enqueue_js' => WPBakery_Helpers::get_backend_view_js( 'woocommerce-template' ),
		];
	}

}