<?php
namespace TotalThemeCore\Vcex\WPBakery\Map;

use TotalThemeCore\Vcex\WPBakery\Shortcode_Params;
use Vcex_WooCommerce_Content as Shortcode;

defined( 'ABSPATH' ) || exit;

/**
 * Register shortcode with the WPBakery page builder.
 *
 * @package TotalThemeCore
 * @version 1.4.6
 */
final class WooCommerce_Content {

	/**
	 * Constructor.
	 */
	public function __construct() {
		add_action( 'vc_after_mapping', [ __CLASS__, 'vc_after_mapping' ] );

	}

	/**
	 * Run functions on vc_after_mapping hook.
	 */
	public static function vc_after_mapping() {
		vc_lean_map( Shortcode::TAG, [ __CLASS__, 'map' ] );
	}

	/**
	 * Map shortcode via vc_lean_map.
	 */
	public static function map() {
		$category = [ 'WooCommerce' ];
		$branding = vcex_shortcodes_branding();
		if ( $branding ) {
			$category[] = $branding;
		}
		return [
			'name'                    => Shortcode::get_title(),
			'description'             => esc_html__( 'Returns the output of woocommerce_content()', 'total-theme-core' ),
			'base'                    => Shortcode::TAG,
			'icon'                    => 'vcex_element-icon vcex_element-icon--woocommerce',
			'category'                => $category,
			'params'                  => Shortcode_Params::get( 'Vcex_WooCommerce_Content' ),
			'show_settings_on_create' => false,
		];
	}

}