<?php
namespace TotalThemeCore\Vcex\WPBakery\Map;

use VCEX_Toggle_Shortcode as Shortcode;

use TotalThemeCore\Vcex\WPBakery\Shortcode_Params;
use TotalThemeCore\Vcex\WPBakery\Helpers as WPBakery_Helpers;

defined( 'ABSPATH' ) || exit;

/**
 * Register shortcode with the WPBakery page builder.
 *
 * @package TotalThemeCore
 * @version 1.4.6
 */
final class Toggle {

	/**
	 * Constructor.
	 */
	public function __construct() {
		add_action( 'vc_after_mapping', [ $this, 'vc_after_mapping' ] );
	}

	/**
	 * Run functions on vc_after_mapping hook.
	 */
	public function vc_after_mapping() {
		vc_lean_map( Shortcode::TAG, [ $this, 'map' ] );
	}

	/**
	 * Map shortcode via vc_lean_map.
	 */
	public function map() {
		return [
			'name'             => esc_html__( 'Toggle (FAQ)', 'total-theme-core' ),
			'description'      => esc_html__( 'Show/hide text toggle', 'total-theme-core' ),
			'base'             => Shortcode::TAG,
			'icon'             => 'vcex_element-icon vcex_element-icon--toggle',
			'category'         => vcex_shortcodes_branding(),
			'params'           => Shortcode_Params::get( 'VCEX_Toggle_Shortcode' ),
			'admin_enqueue_js' => WPBakery_Helpers::get_backend_view_js( 'toggle' ),
			'js_view'          => 'vcexToggleView',
		];
	}

}