<?php
namespace TotalThemeCore\Vcex\WPBakery\Map;

use TotalThemeCore\Vcex\WPBakery\Shortcode_Params;
use Vcex_Staff_Social_Shortcode as Shortcode;

defined( 'ABSPATH' ) || exit;

/**
 * Register shortcode with the WPBakery page builder.
 *
 * @package TotalThemeCore
 * @version 1.4.9
 */
final class Staff_Social {

	/**
	 * Constructor.
	 */
	public function __construct() {
		add_action( 'vc_after_mapping', [ $this, 'vc_after_mapping' ] );
	}

	/**
	 * Run functions on vc_after_mapping hook.
	 */
	public function vc_after_mapping() {
		vc_lean_map( Shortcode::TAG, [ $this, 'map' ] );

		$vc_action = vc_request_param( 'action' );

		if ( 'vc_get_autocomplete_suggestion' === $vc_action || 'vc_edit_form' === $vc_action ) {
			add_filter(
				'vc_autocomplete_staff_social_post_id_callback',
				'TotalThemeCore\\WPBakery\\Autocomplete\\Staff_Members::callback'
			);
			add_filter(
				'vc_autocomplete_staff_social_post_id_render',
				'TotalThemeCore\\WPBakery\\Autocomplete\\Staff_Members::render'
			);
		}
	}

	/**
	 * Map shortcode via vc_lean_map.
	 */
	public function map() {
		return array(
			'name'        => esc_html__( 'Staff Social Links', 'total-theme-core' ),
			'description' => esc_html__( 'Single staff social links', 'total-theme-core' ),
			'base'        => Shortcode::TAG,
			'category'    => vcex_shortcodes_branding(),
			'icon'        => 'vcex_element-icon vcex_element-icon--staff-social',
			'params'      => Shortcode_Params::get( 'Vcex_Staff_Social_Shortcode' ),
		);

	}

}