<?php
namespace TotalThemeCore\Vcex\WPBakery\Map;

use TotalThemeCore\Vcex\WPBakery\Shortcode_Params;
use Vcex_Spacing_Shortcode as Shortcode;

defined( 'ABSPATH' ) || exit;

/**
 * Register shortcode with the WPBakery page builder.
 *
 * @package TotalThemeCore
 * @version 1.4.9
 */
final class Spacing {

	/**
	 * Constructor.
	 */
	public function __construct() {
		add_action( 'vc_after_mapping', [ $this, 'vc_after_mapping' ] );
	}

	/**
	 * Run functions on vc_after_mapping hook.
	 */
	public function vc_after_mapping() {
		vc_lean_map( Shortcode::TAG, [ $this, 'map' ] );
	}

	/**
	 * Map shortcode via vc_lean_map.
	 */
	public function map() {
		return [
			'name'        => Shortcode::get_title(),
			'description' => esc_html__( 'Adds spacing anywhere you need it', 'total-theme-core' ),
			'base'        => Shortcode::TAG,
			'category'    => vcex_shortcodes_branding(),
			'icon'        => 'vcex_element-icon vcex_element-icon--spacing',
			'params'      => Shortcode_Params::get( 'Vcex_Spacing_Shortcode' ),
		];
	}

}