<?php
namespace TotalThemeCore\Vcex\WPBakery\Map;

use TotalThemeCore\Vcex\WPBakery\Shortcode_Params;
use VCEX_Post_Excerpt_Shortcode as Shortcode;

defined( 'ABSPATH' ) || exit;

/**
 * Register shortcode with the WPBakery page builder.
 *
 * @package TotalThemeCore
 * @version 1.4.6
 */
final class Post_Excerpt {

	/**
	 * Constructor.
	 */
	public function __construct() {
		add_action( 'vc_after_mapping', array( __CLASS__, 'vc_after_mapping' ) );
	}

	/**
	 * Run functions on vc_after_mapping hook.
	 */
	public static function vc_after_mapping() {
		vc_lean_map( 'vcex_post_excerpt', array( __CLASS__, 'map' ) );
	}

	/**
	 * Map shortcode via vc_lean_map.
	 */
	public static function map() {
		return array(
			'name'        => esc_html__( 'Post Excerpt', 'total-theme-core' ),
			'description' => esc_html__( 'Display post excerpt', 'total-theme-core' ),
			'base'        => 'vcex_post_excerpt',
			'icon'        => 'vcex_element-icon vcex_element-icon--post-content',
			'category'    => vcex_shortcodes_branding(),
			'params'      => Shortcode_Params::get( 'VCEX_Post_Excerpt_Shortcode' ),
		);
	}

}