<?php
namespace TotalThemeCore\Vcex\WPBakery\Map;

use TotalThemeCore\Vcex\WPBakery\Shortcode_Params;
use VCEX_Post_Content_Shortcode as Shortcode;

defined( 'ABSPATH' ) || exit;

/**
 * Register shortcode with the WPBakery page builder.
 *
 * @package TotalThemeCore
 * @version 1.4.6
 */
final class Post_Content {

	/**
	 * Constructor.
	 */
	public function __construct() {
		add_action( 'vc_after_mapping', array( __CLASS__, 'vc_after_mapping' ) );
	}

	/**
	 * Run functions on vc_after_mapping hook.
	 */
	public static function vc_after_mapping() {
		vc_lean_map( 'vcex_post_content', array( __CLASS__, 'map' ) );

		if ( 'vc_edit_form' === vc_post_param( 'action' ) ) {
			add_filter( 'vc_edit_form_fields_attributes_vcex_post_content', array( __CLASS__, 'edit_form_fields' ) );
		}

	}

	/**
	 * Update fields on edit.
	 */
	public static function edit_form_fields( $atts ) {

		if ( empty( $atts['blocks'] ) ) {
			$blocks = array();
			$settings_to_check = array(
				'post_series',
				'the_content',
				'social_share',
				'author_bio',
				'related',
				'comments',
			);
			foreach( $settings_to_check as $setting ) {
				if ( 'the_content' == $setting ) {
					$blocks[] = $setting;
				} elseif ( isset( $atts[$setting] ) && 'true' == $atts[$setting] ) {
					$blocks[] = $setting;
				}
			}

			if ( $blocks ) {
				$atts['blocks'] = implode( ',', $blocks );
			}
		}

		return $atts;
	}

	/**
	 * Map shortcode via vc_lean_map.
	 */
	public static function map() {
		return [
			'name'        => esc_html__( 'Post Content', 'total-theme-core' ),
			'description' => esc_html__( 'Display your post content', 'total-theme-core' ),
			'base'        => 'vcex_post_content',
			'icon'        => 'vcex_element-icon vcex_element-icon--post-content',
			'category'    => vcex_shortcodes_branding(),
			'params'      => Shortcode_Params::get( 'VCEX_Post_Content_Shortcode' ),
		];
	}

}