<?php
namespace TotalThemeCore\Vcex\WPBakery\Map;

use VCEX_Comments_Shortcode;
use TotalThemeCore\Vcex\WPBakery\Shortcode_Params;

defined( 'ABSPATH' ) || exit;

/**
 * Register shortcode with the WPBakery page builder.
 *
 * @version 1.4.6
 */
final class Post_Comments {

	/**
	 * Constructor.
	 */
	public function __construct() {
		add_action( 'vc_after_mapping', __CLASS__ . '::vc_after_mapping' );
	}

	/**
	 * Run functions on vc_after_mapping hook.
	 */
	public static function vc_after_mapping() {
		vc_lean_map( VCEX_Comments_Shortcode::TAG, __CLASS__ . '::map' );
	}

	/**
	 * Map shortcode via vc_lean_map.
	 */
	public static function map() {
		return array(
			'name'        => esc_html__( 'Post Comments', 'total-theme-core' ),
			'description' => esc_html__( 'Display your post comments', 'total-theme-core' ),
			'base'        => 'vcex_post_comments',
			'icon'        => 'vcex_element-icon vcex_element-icon--post-comments',
			'category'    => vcex_shortcodes_branding(),
			'params'      => Shortcode_Params::get( 'VCEX_Comments_Shortcode' ),
		);
	}

}