<?php
namespace TotalThemeCore\Vcex\WPBakery\Map;

use TotalThemeCore\Vcex\WPBakery\Shortcode_Params;
use Wpex_Post_Cards_Shortcode as Shortcode;

defined( 'ABSPATH' ) || exit;

/**
 * Register shortcode with the WPBakery page builder.
 *
 * @package TotalThemeCore
 * @version 1.4.9
 */
final class Post_Cards {

	/**
	 * Constructor.
	 */
	public function __construct() {
		add_action( 'vc_after_mapping', [ __CLASS__, 'vc_after_mapping' ] );
	}

	/**
	 * Run functions on vc_after_mapping hook.
	 */
	public static function vc_after_mapping() {
		vc_lean_map( Shortcode::TAG, [ __CLASS__, 'map' ] );

		$vc_action = vc_request_param( 'action' );

		if ( 'vc_get_autocomplete_suggestion' === $vc_action || 'vc_edit_form' === $vc_action ) {

			/*
			// Categories taxonomy
			// @todo allow you to select a taxonomy for the cards taxonomy.
			add_filter(
				'vc_autocomplete_wpex_post_cards_categories_taxonomy_callback',
				'TotalThemeCore\\WPBakery\\Autocomplete\\Taxonomies::callback'
			);
			add_filter(
				'vc_autocomplete_wpex_post_cards_categories_taxonomy_render',
				'TotalThemeCore\\WPBakery\\Autocomplete\\Taxonomies::render'
			);
			*/

			// Terms.
			add_filter(
				'vc_autocomplete_wpex_post_cards_terms_in_callback',
				'TotalThemeCore\\WPBakery\\Autocomplete\\Taxonomy_Terms_Ids::callback'
			);
			add_filter(
				'vc_autocomplete_wpex_post_cards_terms_in_render',
				'TotalThemeCore\\WPBakery\\Autocomplete\\Taxonomy_Terms_Ids::render'
			);
			add_filter(
				'vc_autocomplete_wpex_post_cards_terms_not_in_callback',
				'TotalThemeCore\\WPBakery\\Autocomplete\\Taxonomy_Terms_Ids::callback'
			);
			add_filter(
				'vc_autocomplete_wpex_post_cards_terms_not_in_render',
				'TotalThemeCore\\WPBakery\\Autocomplete\\Taxonomy_Terms_Ids::render'
			);

			// Author query.
			add_filter(
				'vc_autocomplete_wpex_post_cards_author_in_callback',
				'TotalThemeCore\\WPBakery\\Autocomplete\\Users::callback'
			);
			add_filter(
				'vc_autocomplete_wpex_post_cards_author_in_render',
				'TotalThemeCore\\WPBakery\\Autocomplete\\Users::render'
			);

			// Posts In query.
			add_filter(
				'vc_autocomplete_wpex_post_cards_posts_in_callback',
				'vc_include_field_search'
			);
			add_filter(
				'vc_autocomplete_wpex_post_cards_posts_in_render',
				'vc_include_field_render'
			);

			// Featured Card ID.
			add_filter(
				'vc_autocomplete_wpex_post_cards_featured_post_id_callback',
				'vc_include_field_search'
			);
			add_filter(
				'vc_autocomplete_wpex_post_cards_featured_post_id_render',
				'vc_include_field_render'
			);

		}

		if ( 'vc_edit_form' === vc_post_param( 'action' ) ) {
			add_filter(
				'vc_edit_form_fields_attributes_wpex_post_cards',
				[ __CLASS__, 'edit_form_fields' ]
			);
		}
	}

	/**
	 * Parse shortcode attributes..
	 */
	public static function edit_form_fields( $atts ) {
		$atts = Shortcode::parse_deprecated_attributes( $atts );
		return $atts;
	}

	/**
	 * Map shortcode via vc_lean_map.
	 */
	public static function map() {
		return [
			'name'        => esc_html__( 'Post Cards', 'total-theme-core' ),
			'description' => esc_html__( 'Post based card list, grid or carousel.', 'total-theme-core' ),
			'base'        => Shortcode::TAG,
			'icon'        => 'vcex_element-icon vcex_element-icon--post-cards',
			'category'    => vcex_shortcodes_branding(),
			'params'      => Shortcode_Params::get( 'Wpex_Post_Cards_Shortcode' ),
		];
	}

}