<?php
namespace TotalThemeCore\Vcex\WPBakery\Map;

use TotalThemeCore\Vcex\WPBakery\Shortcode_Params;

defined( 'ABSPATH' ) || exit;

/**
 * Register shortcode with the WPBakery page builder.
 *
 * @version 1.4.6
 */
final class Page_Title {

	/**
	 * Constructor.
	 */
	public function __construct() {
		add_action( 'vc_after_mapping', __CLASS__ . '::vc_after_mapping' );
	}

	/**
	 * Run functions on vc_after_mapping hook.
	 */
	public static function vc_after_mapping() {
		vc_lean_map( 'vcex_page_title', __CLASS__ . '::map' );
	}

	/**
	 * Map shortcode via vc_lean_map.
	 */
	public static function map() {
		return array(
			'name'        => esc_html__( 'Page Title', 'total-theme-core' ),
			'description' => esc_html__( 'Current page title', 'total-theme-core' ),
			'base'        => 'vcex_page_title',
			'icon'        => 'vcex_element-icon vcex_element-icon--page-title',
			'category'    => vcex_shortcodes_branding(),
			'params'      => Shortcode_Params::get( 'VCEX_Page_Title_Shortcode' ),
		);
	}

}