<?php
namespace TotalThemeCore\Vcex\WPBakery\Map;

use VCEX_List_Item_Shortcode;
use TotalThemeCore\Vcex\WPBakery\Shortcode_Params;

defined( 'ABSPATH' ) || exit;

/**
 * Register shortcode with the WPBakery page builder.
 *
 * @package TotalThemeCore
 * @version 1.4.6
 */
final class List_Item {

	/**
	 * Constructor.
	 */
	public function __construct() {
		add_action( 'vc_after_mapping', __CLASS__ . '::vc_after_mapping' );
	}

	/**
	 * Run functions on vc_after_mapping hook.
	 */
	public static function vc_after_mapping() {
		vc_lean_map( 'vcex_list_item', __CLASS__ . '::map' );

		if ( 'vc_edit_form' === vc_post_param( 'action' ) ) {
			add_filter( 'vc_edit_form_fields_attributes_vcex_list_item', __CLASS__ . '::edit_fields', 10 );
		}
	}

	/**
	 * Edit form fields.
	 */
	public static function edit_fields( $atts ) {
		$atts = vcex_parse_icon_param( $atts );
		$atts = VCEX_List_Item_Shortcode::parse_deprecated_attributes( $atts );
		return $atts;
	}

	/**
	 * Map shortcode via vc_lean_map.
	 */
	public static function map() {
		return array(
			'name'        => esc_html__( 'List Item', 'total-theme-core' ),
			'description' => esc_html__( 'Single list item with icon', 'total-theme-core' ),
			'base'        => 'vcex_list_item',
			'icon'        => 'vcex_element-icon vcex_element-icon--list-item',
			'category'    => vcex_shortcodes_branding(),
			'params'      => Shortcode_Params::get( 'VCEX_List_Item_Shortcode' ),
		);
	}

}