<?php
namespace TotalThemeCore\Vcex\WPBakery\Map;

use VCEX_Image_Flexslider_Shortcode as Shortcode;

use TotalThemeCore\Vcex\WPBakery\Shortcode_Params;
use TotalThemeCore\Vcex\WPBakery\Helpers as WPBakery_Helpers;
use TotalThemeCore\Vcex\WPBakery\Views\Backend\Image_Gallery\View as Backend_View;

defined( 'ABSPATH' ) || exit;

/**
 * Register shortcode with the WPBakery page builder.
 *
 * @package TotalThemeCore
 * @version 1.5.1
 */
final class Image_Flexslider {

	/**
	 * Constructor.
	 */
	public function __construct() {
		add_action( 'vc_after_mapping', array( __CLASS__, 'vc_after_mapping' ) );

		if ( is_admin() ) {
			Backend_View::instance();
		}
	}

	/**
	 * Run functions on vc_after_mapping hook.
	 */
	public static function vc_after_mapping() {
		vc_lean_map( Shortcode::TAG, array( __CLASS__, 'map' ) );
	}

	/**
	 * Map shortcode via vc_lean_map.
	 */
	public static function map() {
		return array(
			'name'             => esc_html__( 'Image Slider', 'total-theme-core' ),
			'description'      => esc_html__( 'Custom image slider', 'total-theme-core' ),
			'base'             => Shortcode::TAG,
			'admin_enqueue_js' => WPBakery_Helpers::get_backend_view_js( 'image-gallery' ),
			'js_view'          => 'vcexBackendViewImageGallery',
			'category'         => vcex_shortcodes_branding(),
			'icon'             => 'vcex_element-icon vcex_element-icon--image-gallery',
			'params'           => Shortcode_Params::get( 'VCEX_Image_Flexslider_Shortcode' ),
		);
	}

}