<?php
namespace TotalThemeCore\Vcex\WPBakery\Map;

use VCEX_Icon_Box_Shortcode as Shortcode;

use TotalThemeCore\Vcex\WPBakery\Shortcode_Params;
use TotalThemeCore\Vcex\WPBakery\Helpers as WPBakery_Helpers;

defined( 'ABSPATH' ) || exit;

/**
 * Register shortcode with the WPBakery page builder.
 *
 * @version 1.5.1
 */
final class Icon_Box {

	/**
	 * Constructor.
	 */
	public function __construct() {
		add_action( 'vc_after_mapping', [ $this, 'vc_after_mapping' ] );
	}

	/**
	 * Run functions on vc_after_mapping hook.
	 */
	public function vc_after_mapping() {
		vc_lean_map( 'vcex_icon_box', [ $this, 'map' ] );

		if ( 'vc_edit_form' === vc_post_param( 'action' ) ) {
			add_filter( 'vc_edit_form_fields_attributes_vcex_icon_box', [ $this, 'edit_fields' ], 10 );
		}
	}

	/**
	 * Edit form fields.
	 */
	public function edit_fields( $atts ) {
		$atts = vcex_parse_icon_param( $atts );
		$atts = Shortcode::parse_deprecated_attributes( $atts );
		return $atts;
	}

	/**
	 * Map shortcode via vc_lean_map.
	 */
	public function map() {
		return [
			'name'             => esc_html__( 'Icon Box (Blurb)', 'total-theme-core' ),
			'base'             => 'vcex_icon_box',
			'category'         => vcex_shortcodes_branding(),
			'icon'             => 'vcex_element-icon vcex_element-icon--icon-box',
			'description'      => esc_html__( 'Content box with icon', 'total-theme-core' ),
			'admin_enqueue_js' => WPBakery_Helpers::get_backend_view_js( 'icon-box' ),
			'js_view'          => 'vcexIconBoxVcBackendView',
			'params'           => Shortcode_Params::get( 'VCEX_Icon_Box_Shortcode' ),
		];
	}

}