<?php
namespace TotalThemeCore\Vcex\WPBakery\Map;

use VCEX_Heading_Shortcode as Shortcode;

use TotalThemeCore\Vcex\WPBakery\Shortcode_Params;
use TotalThemeCore\Vcex\WPBakery\Helpers as WPBakery_Helpers;

defined( 'ABSPATH' ) || exit;

/**
 * Register shortcode with the WPBakery page builder.
 *
 * @package TotalThemeCore
 * @version 1.5.1
 */
final class Heading {

	/**
	 * Constructor.
	 */
	public function __construct() {
		add_action( 'vc_after_mapping', [ $this, 'vc_after_mapping' ] );
	}

	/**
	 * Run functions on vc_after_mapping hook.
	 */
	public function vc_after_mapping() {
		vc_lean_map( Shortcode::TAG, [ $this, 'map' ] );

		if ( 'vc_edit_form' === vc_post_param( 'action' ) ) {
			add_filter( 'vc_edit_form_fields_attributes_vcex_heading', [ $this, 'edit_fields' ] );
		}
	}

	/**
	 * Edit form fields.
	 */
	public function edit_fields( $atts ) {
		$atts = vcex_parse_icon_param( $atts );
		$atts = Shortcode::parse_deprecated_attributes( $atts );
		return $atts;
	}

	/**
	 * Map shortcode via vc_lean_map.
	 */
	public static function map() {
		return [
			'name'             => esc_html__( 'Heading', 'total-theme-core' ),
			'description'      => esc_html__( 'Advanced heading element', 'total-theme-core' ),
			'base'             => Shortcode::TAG,
			'category'         => vcex_shortcodes_branding(),
			'icon'             => 'vcex_element-icon vcex_element-icon--heading',
			'admin_enqueue_js' => WPBakery_Helpers::get_backend_view_js( 'heading' ),
			'js_view'          => 'vcexHeadingView',
			'params'           => Shortcode_Params::get( 'VCEX_Heading_Shortcode' ),
		];
	}

}