<?php
namespace TotalThemeCore\Vcex\WPBakery\Map;

use TotalThemeCore\Vcex\WPBakery\Shortcode_Params;
use Vcex_Multi_Color_Divider_Shortcode as Shortcode;

defined( 'ABSPATH' ) || exit;

/**
 * Register shortcode with the WPBakery page builder.
 *
 * @package TotalThemeCore
 * @version 1.4.9
 */
final class Divider_Multicolor {

	/**
	 * Constructor.
	 */
	public function __construct() {
		add_action( 'vc_after_mapping', [ $this, 'vc_after_mapping' ] );
	}

	/**
	 * Run functions on vc_after_mapping hook.
	 */
	public function vc_after_mapping() {
		vc_lean_map( Shortcode::TAG, [ $this, 'map' ] );
	}

	/**
	 * Map shortcode via vc_lean_map.
	 */
	public function map() {
		return [
			'name'        => Shortcode::get_title(),
			'description' => esc_html__( 'A multicolor divider', 'total-theme-core' ),
			'base'        => Shortcode::TAG,
			'category'    => vcex_shortcodes_branding(),
			'icon'        => 'vcex_element-icon vcex_element-icon--divider-multicolor',
			'params'      => Shortcode_Params::get( 'Vcex_Multi_Color_Divider_Shortcode' ),
		];
	}

}