<?php
namespace TotalThemeCore\Vcex\WPBakery\Map;

use TotalThemeCore\Vcex\WPBakery\Shortcode_Params;

defined( 'ABSPATH' ) || exit;

/**
 * Register shortcode with the WPBakery page builder.
 *
 * @version 1.4.6
 */
final class Contact_Form {

	/**
	 * Constructor.
	 */
	public function __construct() {
		add_action( 'vc_after_mapping', __CLASS__ . '::vc_after_mapping' );
	}

	/**
	 * Run functions on vc_after_mapping hook.
	 */
	public static function vc_after_mapping() {
		vc_lean_map( 'vcex_contact_form', __CLASS__ . '::map' );
	}

	/**
	 * Map shortcode via vc_lean_map.
	 */
	public static function map() {
		return array(
			'name'        => esc_html__( 'Contact Form', 'total-theme-core' ),
			'description' => esc_html__( 'Simple contact form', 'total-theme-core' ),
			'base'        => 'vcex_contact_form',
			'icon'        => 'vcex_element-icon vcex_element-icon--contact',
			'category'    => vcex_shortcodes_branding(),
			'params'      => Shortcode_Params::get( 'VCEX_Contact_Form_Shortcode' ),
		);
	}

}