<?php
namespace TotalThemeCore\Vcex\WPBakery\Map;

use TotalThemeCore\Vcex\WPBakery\Shortcode_Params;
use VCEX_Callout_Shortcode as Shortcode;

defined( 'ABSPATH' ) || exit;

/**
 * Register shortcode with the WPBakery page builder.
 *
 * @package TotalThemeCore
 * @version 1.4.6
 */
final class Callout {

	/**
	 * Constructor.
	 */
	public function __construct() {
		add_action( 'vc_after_mapping', array( __CLASS__, 'vc_after_mapping' ) );
	}

	/**
	 * Run functions on vc_after_mapping hook.
	 */
	public static function vc_after_mapping() {
		vc_lean_map( Shortcode::TAG, array( __CLASS__, 'map' ) );

		if ( 'vc_edit_form' === vc_post_param( 'action' ) ) {
			add_filter( 'vc_edit_form_fields_attributes_vcex_callout', array( __CLASS__, 'edit_form_fields' ) );
		}
	}

	/**
	 * Update fields on edit.
	 */
	public static function edit_form_fields( $atts ) {
		$atts = vcex_parse_icon_param( $atts, 'button_icon_left' );
		$atts = vcex_parse_icon_param( $atts, 'button_icon_right' );
		$atts = Shortcode::parse_deprecated_attributes( $atts );
		return $atts;
	}

	/**
	 * Map shortcode via vc_lean_map.
	 */
	public static function map() {
		return array(
			'name'        => esc_html__( 'Callout', 'total' ),
			'description' => esc_html__( 'Call to action section with or without button', 'total' ),
			'base'        => Shortcode::TAG,
			'icon'        => 'vcex_element-icon vcex_element-icon--callout',
			'category'    => vcex_shortcodes_branding(),
			'params'      => Shortcode_Params::get( 'VCEX_Callout_Shortcode' ),
		);
	}

}