<?php
namespace TotalThemeCore\Vcex\WPBakery\Map;

use VCEX_Button_Shortcode;
use TotalThemeCore\Vcex\WPBakery\Shortcode_Params;

defined( 'ABSPATH' ) || exit;

/**
 * Register shortcode with the WPBakery page builder.
 *
 * @package TotalThemeCore
 * @version 1.4.6
 */
final class Button {

	/**
	 * Constructor.
	 */
	public function __construct() {
		add_action( 'vc_after_mapping', array( __CLASS__, 'vc_after_mapping' ) );
	}

	/**
	 * Run functions on vc_after_mapping hook.
	 */
	public static function vc_after_mapping() {
		vc_lean_map( 'vcex_button', array( __CLASS__, 'map' ) );

		if ( 'vc_edit_form' === vc_post_param( 'action' ) ) {
			add_filter( 'vc_edit_form_fields_attributes_vcex_button', array( __CLASS__, 'edit_form_fields' ) );
		}

	}

	/**
	 * Update fields on edit.
	 */
	public static function edit_form_fields( $atts ) {
		$atts = VCEX_Button_Shortcode::parse_deprecated_attributes( $atts );
		$atts = vcex_parse_icon_param( $atts, 'icon_left' );
		$atts = vcex_parse_icon_param( $atts, 'icon_right' );
		return $atts;
	}

	/**
	 * Map shortcode via vc_lean_map.
	 */
	public static function map() {
		return array(
			'name'        => esc_html__( 'Theme Button', 'total-theme-core' ),
			'description' => esc_html__( 'Customizable button', 'total-theme-core' ),
			'base'        => 'vcex_button',
			'category'    => vcex_shortcodes_branding(),
			'icon'        => 'vcex_element-icon vcex_element-icon--button',
			'params'      => Shortcode_Params::get( 'VCEX_Button_Shortcode' ),
		);
	}

}