<?php
namespace TotalThemeCore\Vcex\WPBakery\Map;

use TotalThemeCore\Vcex\WPBakery\Shortcode_Params;
use Vcex_Blog_Carousel_Shortcode as Shortcode;

defined( 'ABSPATH' ) || exit;

/**
 * Register shortcode with the WPBakery page builder.
 *
 * @package TotalThemeCore
 * @version 1.4.9
 */
final class Blog_Carousel {

	/**
	 * Constructor.
	 */
	public function __construct() {
		add_action( 'vc_after_mapping', array( $this, 'vc_after_mapping' ) );
	}

	/**
	 * Run functions on vc_after_mapping hook.
	 */
	public function vc_after_mapping() {
		vc_lean_map( Shortcode::TAG, array( $this, 'map' ) );

		$vc_action = vc_request_param( 'action' );

		if ( 'vc_get_autocomplete_suggestion' === $vc_action || 'vc_edit_form' === $vc_action ) {

			// Get autocomplete suggestion.
			add_filter(
				'vc_autocomplete_vcex_blog_carousel_include_categories_callback',
				'TotalThemeCore\\WPBakery\\Autocomplete\\Categories::callback',
				10,
				1
			);
			add_filter(
				'vc_autocomplete_vcex_blog_carousel_exclude_categories_callback',
				'TotalThemeCore\\WPBakery\\Autocomplete\\Categories::callback',
				10,
				1
			);

			// Render autocomplete suggestions.
			add_filter(
				'vc_autocomplete_vcex_blog_carousel_include_categories_render',
				'TotalThemeCore\\WPBakery\\Autocomplete\\Categories::render',
				10,
				1
			);
			add_filter(
				'vc_autocomplete_vcex_blog_carousel_exclude_categories_render',
				'TotalThemeCore\\WPBakery\\Autocomplete\\Categories::render',
				10,
				1
			);

		}

		if ( 'vc_edit_form' === $vc_action ) {
			add_filter(
				'vc_edit_form_fields_attributes_vcex_blog_carousel',
				'vcex_parse_deprecated_grid_entry_content_css'
			);
		}
	}

	/**
	 * Map shortcode via vc_lean_map.
	 */
	public function map() {
		return array(
			'name'        => Shortcode::get_title(),
			'description' => esc_html__( 'Recent blog posts carousel', 'total-theme-core' ),
			'base'        => Shortcode::TAG,
			'category'    => vcex_shortcodes_branding(),
			'icon'        => 'vcex_element-icon vcex_element-icon--carousel',
			'params'      => Shortcode_Params::get( 'Vcex_Blog_Carousel_Shortcode' ),
		);
	}

}