<?php
namespace TotalThemeCore\Vcex\WPBakery\Map;

use TotalThemeCore\Vcex\WPBakery\Shortcode_Params;
use Vcex_Alert_Shortcode as Shortcode;

defined( 'ABSPATH' ) || exit;

/**
 * Register shortcode with the WPBakery page builder.
 *
 * @package TotalThemeCore
 * @version 1.5.1
 */
final class Alert {

	/**
	 * Constructor.
	 */
	public function __construct() {
		add_action( 'vc_after_mapping', [ __CLASS__, 'vc_after_mapping' ] );
	}

	/**
	 * Run functions on vc_after_mapping hook.
	 */
	public static function vc_after_mapping() {
		vc_lean_map( Shortcode::TAG, [ __CLASS__, 'map' ] );
	}

	/**
	 * Map shortcode via vc_lean_map.
	 */
	public static function map() {
		return [
			'name'        => Shortcode::get_title(),
			'description' => esc_html__( 'Display an alert or notice.', 'total-theme-core' ),
			'base'        => Shortcode::TAG,
			'icon'        => 'vcex_element-icon vcex_element-icon--alert',
			'category'    => vcex_shortcodes_branding(),
			'params'      => Shortcode_Params::get( 'Vcex_Alert_Shortcode' ),
		];
	}

}