<?php
/**
 * vcex_social_share shortcode.
 *
 * @package Total WordPress Theme
 * @subpackage Total Theme Core
 * @version 1.5.1
 */

defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'wpex_social_share_list' )
	|| ! function_exists( 'wpex_social_share_data' )
	|| ! function_exists( 'wpex_social_share_list' )
	|| ! function_exists( 'wpex_social_share_items' )
) {
	return;
}

$atts      = vcex_shortcode_atts( 'vcex_social_share', $atts, 'VCEX_Social_Share_Shortcode' );
$is_custom = vcex_validate_att_boolean( 'is_custom', $atts, false );

if ( ! empty( $atts[ 'sites' ] ) ) {
	$sites = (array) vcex_vc_param_group_parse_atts( $atts[ 'sites' ] );
}

if ( empty( $sites ) || ! is_array( $sites ) ) {
	return;
}

$sites_array = [];
foreach ( $sites as $k => $v ) {
	if ( is_array( $v ) && isset( $v[ 'site' ] ) ) {
		$sites_array[] = $v[ 'site' ];
	}
}

$shortcode_class = [
	'vcex-module',
	'vcex-social-share',
];

if ( $atts['bottom_margin'] && $bottom_margin_class = vcex_parse_margin_class( $atts['bottom_margin'], 'wpex-mb-' ) ) {
	$shortcode_class[] = $bottom_margin_class;
}

if ( $atts['css_animation'] && $css_animation_class = vcex_get_css_animation( $atts['css_animation'] ) ) {
	$shortcode_class[] = $css_animation_class;
}

if ( $is_custom ) {
	$expand_buttons = vcex_validate_att_boolean( 'expand', $atts, false );
	$shortcode_class[] = 'wpex-flex';
	if ( $expand_buttons ) {
		$shortcode_class[] = 'wpex-overflow-x-auto';
		$shortcode_class[] = 'wpex-hide-scrollbar';
	} else {
		$shortcode_class[] = 'wpex-flex-wrap';
		if ( ! empty( $atts['align'] ) ) {
			$shortcode_class[] = vcex_parse_justify_content_class( $atts['align'] );
		}
	}
	$shortcode_class[] = 'wpex-gap-5';

	$unique_classname = vcex_element_unique_classname();
	$shortcode_css = '';
	$parent_css = vcex_inline_style( [
		'font_size' => $atts['button_font_size'] ?? null,
		'gap'       => $atts['gap'] ?? null,
	], false );
	if ( $parent_css ) {
		$shortcode_css .= '.' . $unique_classname . '{' . $parent_css . '}';
	}
	$button_css = vcex_inline_style( [
		'min_height'     => $atts['button_height'] ?? null,
		'min_width'      => $atts['button_width'] ?? null,
		'padding_top'    => $atts['button_padding_y'] ?? null,
		'padding_bottom' => $atts['button_padding_y'] ?? null,
		'padding_left'   => $atts['button_padding_x'] ?? null,
		'padding_right'  => $atts['button_padding_x'] ?? null,
	], false );
	if ( $button_css ) {
		$shortcode_css .= '.' . $unique_classname . ' .vcex-social-share__button{' . $button_css . '}';
	}
	if ( $shortcode_css ) {
		$shortcode_class[] = $unique_classname;
		echo '<style>' . esc_attr( $shortcode_css ) . '</style>';
	}

}

if ( ! empty( $atts['el_class'] ) ) {
	$shortcode_class[] = vcex_get_extra_class( $atts['el_class'] );
}

$shortcode_class = vcex_parse_shortcode_classes( $shortcode_class, 'vcex_social_share', $atts );

$inline_style = [
	'animation_delay'    => $atts['animation_delay'] ?? null,
	'animation_duration' => $atts['animation_duration'] ?? null,
];

// Custom Design.
if ( $is_custom ) {

	wp_enqueue_script( 'wpex-social-share' );

	$social_items = wpex_social_share_items();
	$has_labels   = vcex_validate_att_boolean( 'has_labels', $atts, false );

	if ( ! empty( $atts['button_border_radius'] ) ) {
		$border_radius_class = vcex_parse_border_radius_class( $atts['button_border_radius'] );
	} else {
		$border_radius_class = $has_labels ? 'wpex-rounded-sm' : 'wpex-rounded-full';
	}
	?>

	<div class="<?php echo esc_attr( $shortcode_class ); ?>"<?php echo vcex_get_unique_id( $atts[ 'unique_id' ] ?? null ); ?><?php echo vcex_inline_style( $inline_style ); ?> <?php wpex_social_share_data( vcex_get_the_ID(), $sites_array ); ?>><?php

		foreach ( $sites as $k => $v ) {
			$social_site = $v['site'] ?? '';
			if ( ! $social_site || ! array_key_exists( $social_site, $social_items ) ) {
				continue;
			}
			$icon = '';
			$icon_class = $social_items[$social_site]['icon_class'] ?? null;
			if ( $icon_class && function_exists( 'wpex_get_theme_icon_html' ) ) {
				$icon = wpex_get_theme_icon_html( $icon_class );
			}
			if ( $icon ) {
				$button_class = [
					'vcex-social-share__button',
					$border_radius_class,
					'wpex-' . sanitize_html_class( $social_site ),
				];

				if ( ! empty( $atts['button_style'] ) && 'default' !== $atts['button_style'] ) {
					$button_class[] = vcex_get_social_button_class( $atts['button_style'] ); // @todo include support
				} else {
					$button_class[] = 'wpex-social-btn';
					$button_class[] = 'wpex-social-bg';
				}

				if ( $has_labels ) {
					$button_class[] = 'wpex-w-auto';
				//	$button_class[] = 'wpex-h-auto'; // deprecated when switching to flex styles.
					$button_class[] = 'wpex-py-5';
					$button_class[] = 'wpex-px-15';
				}

				if ( $expand_buttons ) {
					$button_class[] = 'wpex-flex-grow';
				}

				if ( ! empty( $atts['button_font_weight'] ) ) {
					$button_class[] = vcex_parse_font_weight_class( $atts['button_font_weight'] );
				}

				echo '<button class="' . esc_attr( implode( ' ', array_filter( $button_class ) ) ) . '">' . $icon;
				if ( $has_labels ) {
					$label = wpex_get_translated_theme_mod( 'social_share_' . $social_site . '_label' );
					if ( ! $label ) {
						$label = $social_items[$social_site]['label'] ?? $social_site;
					}
					if ( $label ) {
						echo '<span class="vcex-social-share__label wpex-hidden wpex-sm-inline wpex-ml-5">' . esc_html( $label ) . '</span>';
					}
				} else {
					echo '<span class="screen-reader-text">' . esc_html( $social_items[$social_site]['reader_text'] ?? $social_site ) . '</span>';
				}
				echo '</button>';
			}
		}

	?></div>

<?php }

// Default social share design.
else {

	// Social share function arguments.
	$args = [
		'position' => 'horizontal',
	];

	if ( ! empty( $atts['style'] ) ) {
		$args['style'] = $atts['style'];
	}

	if ( ! empty( $atts['align'] ) ) {
		$args['align'] = $atts['align'];
	}

	?>
	<div class="<?php echo esc_attr( $shortcode_class ); ?>"<?php echo vcex_get_unique_id( $atts[ 'unique_id' ] ?? null ); ?><?php echo vcex_inline_style( $inline_style ); ?>>
		<div <?php wpex_social_share_class( $args ); ?> <?php wpex_social_share_data( vcex_get_the_ID(), $sites_array ); ?>>
			<?php wpex_social_share_list( $args, $sites_array ); ?>
		</div>
	</div>
<?php } ?>