<?php
/**
 * vcex_social_links shortcode output.
 *
 * @package Total WordPress Theme
 * @subpackage Total Theme Core
 * @version 1.5.1
 */

defined( 'ABSPATH' ) || exit;

// Get social profiles array | Used for fallback method and to grab icon styles.
$social_profiles = (array) vcex_social_links_profiles();

// Social profile array can't be empty.
if ( ! $social_profiles ) {
	return;
}

// Define main vars.
$html              = '';
$expand            = vcex_validate_att_boolean( 'expand', $atts );
$show_label        = vcex_validate_att_boolean( 'show_label', $atts );
$show_author_links = vcex_validate_att_boolean( 'author_links', $atts );
$style             = ! empty( $atts['style'] ) ? $atts['style'] : 'flat';
$spacing           = ! empty( $atts['spacing'] ) ? absint( $atts['spacing'] ) : '5';

// Get current author social links.
if ( $show_author_links ) {
	$post_tmp    = get_post( vcex_get_the_ID() );
	$post_author = $post_tmp->post_author;

	if ( ! $post_author ) {
		return;
	}

	$loop = [];
	$social_settings = wpex_get_user_social_profile_settings_array();

	foreach ( $social_settings as $id => $label ) {
		if ( $url = get_the_author_meta( 'wpex_'. $id, $post_author ) ) {
			$loop[$id] = $url;
		}
	}

	$post_tmp = '';

} else {

	// Display custom social links.
	// New method since 3.5.0 | must check $atts value due to fallback and default var
	if ( ! empty( $has_social_links ) ) {
		$social_links = (array) vcex_vc_param_group_parse_atts( $atts['social_links'] );
		$loop = [];
		foreach ( $social_links as $key => $val ) {
			if ( ! empty( $val['site'] ) ) {
				$loop[$val['site']] = isset( $val['link'] ) ? do_shortcode( $val['link'] ) : '';
			}
		}
	} else {
		$loop = [];
		foreach ( $social_profiles as $key => $val ) {
			$loop[$key] = '';
		}
	}

}

// Loop is required.
if ( ! is_array( $loop ) ) {
	return;
}

// Wrap attributes.
$wrap_attrs = [
	'id' => $atts['unique_id'] ?? null,
];

// Wrap classes.
$wrap_classes = [
	'vcex-social-links',
];

if ( $expand ) {
	$wrap_classes[] = 'vcex-social-links--expand';
}

$wrap_classes = array_merge( $wrap_classes, [
	'vcex-module',
	// Utility classes
	'wpex-flex',
	'wpex-items-center',
	'wpex-flex-wrap',
	'wpex-social-btns',
	'vcex-social-btns', // old class
] );

if ( $spacing ) {
	$wrap_classes[] = vcex_parse_gap_class( $spacing );
}

if ( ! empty( $atts['bottom_margin'] )  ) {
	$wrap_classes[] = vcex_sanitize_margin_class( $atts['bottom_margin'], 'wpex-mb-' );
}

if ( ! empty( $atts['align'] ) ) {
	$wrap_classes[] = vcex_parse_justify_content_class( $atts['align'] );
}

if ( ! empty( $atts['visibility'] ) ) {
	$wrap_classes[] = vcex_parse_visibility_class( $atts['visibility'] );
}

if ( ! empty( $atts['css_animation'] ) ) {
	$wrap_classes[] = vcex_get_css_animation( $atts['css_animation'] );
}

if ( ! empty( $atts['classes'] ) ) {
	$wrap_classes[] = vcex_get_extra_class( $atts['classes'] );
}

$wrap_classes[] = 'wpex-last-mr-0';

// Link Classes.
$link_class   = [
	'vcex-social-links__item',
];
$link_class[] = vcex_get_social_button_class( $style );

if ( ! empty( $atts['height'] ) ) {
	$link_class[] = 'wpex-inline-flex';
	$link_class[] = 'wpex-flex-column';
	$link_class[] = 'wpex-items-center';
	$link_class[] = 'wpex-justify-center';
	$link_class[] = 'wpex-leading-none';
}

if ( ! empty( $atts['color'] ) ) {
	$link_class[] = 'wpex-has-custom-color';
}

// @todo can we do this via inline_css?
$a_style_args = [];
if ( ! empty( $atts['width'] ) ) {
	if ( $expand || $show_label ) {
		$a_style_args['min_width'] = $atts['width'];
	} else {
		$a_style_args['width'] = $atts['width'];
	}
}

$a_style = vcex_inline_style( $a_style_args, false );

// Reset social button widths/paddings.
if ( $expand || $show_label ) {

	if ( $expand ) {
		$link_class[] = 'wpex-flex-grow';
	}

	$link_class[] = 'wpex-w-auto';
//	$link_class[] = 'wpex-h-auto';  // deprecated when switching to flex styles.

	if ( empty( $atts['height'] ) ) {
		$link_class[] = 'wpex-leading-normal';
	}

	if ( empty( $atts['padding_y'] ) ) {
		$atts['padding_y'] = '5';
	}

	if ( empty( $atts['padding_x'] ) ) {
		$atts['padding_x'] = '15';
	}

}

// Vertical padding.
if ( ! empty( $atts['padding_y'] ) ) {
	$link_class[] = 'wpex-py-' . absint( $atts['padding_y'] );
}

// Horizontal padding.
if ( ! empty( $atts['padding_x'] ) ) {
	$link_class[] = 'wpex-px-' . absint( $atts['padding_x'] );
}

if ( ! empty( $atts['hover_animation'] ) ) {
	$link_class[] = vcex_hover_animation_class( $atts['hover_animation'] );
	vcex_enque_style( 'hover-animations' );
}

if ( ! empty( $atts['css'] ) ) {
	$link_class[] = vcex_vc_shortcode_custom_css_class( $atts['css'] );
}

// Add attributes to array.
$wrap_attrs['class'] = vcex_parse_shortcode_classes( $wrap_classes, 'vcex_social_links', $atts );

// Begin output.
$html .= '<div' . vcex_parse_html_attributes( $wrap_attrs ) . '>';

	// Loop through social profiles.
	foreach ( $loop as $key => $val ) {
		if ( ! array_key_exists( $key, $social_profiles) || 'googleplus' === $key || 'google-plus' === $key ) {
			continue;
		}

		// Sanitize classname.
		$profile_class = $key;

		// Get URL.
		if ( ! $show_author_links && empty( $has_social_links ) && ! empty( $og_atts ) ) {
			$url = $og_atts[$key] ?? '';
		} else {
			$url = $val;
		}

		// Link output.
		if ( $url ) {

			$label = $social_profiles[$key]['label'] ?? ucfirst( wp_strip_all_tags( $key ) );

			$a_attrs = [
				'href'   => esc_url( do_shortcode( $url ) ),
				'class'  => esc_attr( implode( ' ', $link_class ) . ' wpex-' . $profile_class ),
				'target' => $atts['link_target'] ?? null,
			];

			if ( ! $show_label ) {
				$a_attrs['title'] = $label;
			}

			if ( ! empty( $a_style ) ) {
				$a_attrs['style'] = $a_style;
			}

			$html .= '<a '. vcex_parse_html_attributes( $a_attrs ) .'>';

				$icon = $social_profiles[$key]['icon_class'] ?? null;
				$icon_class = 'vcex-social-links__icon';

				if ( $icon ) {
					if ( $show_label ) {
						$icon_class .= ' wpex-mr-10';
					}
					if ( function_exists( 'wpex_get_theme_icon_html' ) ) {
						$html .= wpex_get_theme_icon_html( $icon, $icon_class );
					}
				}

				if ( $show_label ) {
					$html .= '<span class="vcex-social-links__label vcex-label">' . esc_html( $label ) . '</span>';
				} else {
					$html .= '<span class="screen-reader-text">' . esc_html( $label ) . '</span>';
				}

			$html .= '</a>';
		}

	}

$html .= '</div>';

// @codingStandardsIgnoreLine
echo $html;