<?php
/**
 * vcex_searchbar shortcode output.
 *
 * @package Total WordPress Theme
 * @subpackage Total Theme Core
 * @version 1.4.5
 */

defined( 'ABSPATH' ) || exit;

// Get and extract shortcode attributes.
$atts = vcex_shortcode_atts( 'vcex_searchbar', $atts, 'VCEX_Searchbar_Shortcode' );

// Define output var.
$output = '';

// Define main vars.
$placeholder  = ! empty( $atts['placeholder'] ) ? $atts['placeholder'] : esc_html__( 'Keywords...', 'total' );
$button_text  = ! empty( $atts['button_text'] ) ? $atts['button_text'] : esc_html__( 'Search', 'total' );
$breakpoint   = ! empty( $atts['breakpoint'] ) ? $atts['breakpoint'] : 'sm';
$gap          = ! empty( $atts['gap'] ) ? $atts['gap'] : '15';
$input_width  = ! empty( $atts['input_width'] ) ? $atts['input_width'] : '';
$button_width = ! empty( $atts['button_width'] ) ? $atts['button_width'] : '';
$has_button   = vcex_validate_att_boolean( 'has_button', $atts, true );
$has_clear    = vcex_validate_att_boolean( 'has_clear', $atts );
$mobile_stack = vcex_validate_att_boolean( 'fullwidth_mobile', $atts );
$auto_fill    = vcex_validate_att_boolean( 'auto_fill', $atts );

// Set gap to 0 if input with is 100% - this is a fallback for pre 1.4.5
if ( $has_button && '100%' === $input_width && empty( $atts['gap'] ) ) {
	$gap = '0';
}

// Autofocus.
$autofocus = ( vcex_validate_att_boolean( 'autofocus', $atts ) ) ? 'autofocus' : '';

// Inline Styles.
$widths_css = array();
if ( $input_width ) {
	$input_css = vcex_inline_style( array(
		'width' => $input_width,
	), false );
	$widths_css[] = '.vcex-searchbar-input-wrap{' . $input_css . '}';
}

if ( $button_width ) {
	$button_css = vcex_inline_style( array(
		'width' => $button_width,
	), false );
	$widths_css[] = '.vcex-searchbar-button{' . $button_css . '}';
}

if ( $widths_css ) {
	$unique_classname = vcex_element_unique_classname();
	foreach( $widths_css as $css_k => $css_v ) {
		$widths_css[$css_k] = ".$unique_classname $css_v";
	}
	$output .= '<style>';
		if ( $mobile_stack ) {
			switch( $breakpoint ) {
				case 'sm';
					$breakpoint_px = '640';
					break;
				case 'md';
					$breakpoint_px = '768';
					break;
				case 'lg';
					$breakpoint_px = '1024';
					break;
				case 'xl';
					$breakpoint_px = '1280';
					break;
			}
			$output .= '@media only screen and (min-width: ' . $breakpoint_px . 'px) {';
		}
		$output .= esc_attr( implode( '', $widths_css ) );
		if ( $mobile_stack ) {
			$output .= '}';
		}
	$output .= '</style>';
}

// Wrap Classes.
$wrap_classes = array(
	'vcex-module',
	'vcex-searchbar',
);

if ( $has_button && $mobile_stack ) {
	$wrap_classes[] = 'vcex-fullwidth-mobile';
}

if ( $has_clear ) {
	$wrap_classes[] = 'vcex-searchbar--has-clear';
}

$wrap_classes[] = 'wpex-relative';
$wrap_classes[] = 'wpex-max-w-100';
$wrap_classes[] = 'wpex-text-lg';

if ( ! empty( $atts['bottom_margin'] ) ) {
	$wrap_classes[] = vcex_sanitize_margin_class( $atts['bottom_margin'], 'wpex-mb-' );
}

if ( ! empty( $atts['visibility'] ) ) {
	$wrap_classes[] = vcex_parse_visibility_class( $atts['visibility'] );
}

if ( ! empty( $atts['wrap_width'] ) && $atts['wrap_float'] ) {
	$wrap_classes[] = 'wpex-float-' . sanitize_html_class( $atts['wrap_float'] );
}

if ( ! empty( $atts['classes'] ) ) {
	$wrap_classes[] = vcex_get_extra_class( $atts['classes'] );
}

if ( ! empty( $atts['css_animation'] ) ) {
	$wrap_classes[] = vcex_get_css_animation( $atts['css_animation'] );
}

if ( isset( $unique_classname ) ) {
	$wrap_classes[] = $unique_classname;
}

$wrap_classes = vcex_parse_shortcode_classes( $wrap_classes, 'vcex_searchbar', $atts );

// Wrap style.
$wrap_style = vcex_inline_style( array(
	'width'              => $atts['wrap_width'] ?? null,
	'animation_delay'    => $atts['animation_delay'] ?? null,
	'animation_duration' => $atts['animation_duration'] ?? null,
) );

// Form style.
$form_style = vcex_inline_style( array(
	'font_size'      => $atts['input_font_size'] ?? null,
	'text_transform' => $atts['input_text_transform'] ?? null,
	'letter_spacing' => $atts['input_letter_spacing'] ?? null,
	'font_weight'    => $atts['input_font_weight'] ?? null,
) );

// Begin output.
$output .= '<div class="' . esc_attr( $wrap_classes ) . '"' . vcex_get_unique_id( $atts['unique_id'] ?? null ) . $wrap_style . '>';

	$form_class = array(
		'vcex-searchbar-form',
	);

	if ( '100%' === $input_width && '100%' === $button_width ) {
		$form_class[] = 'wpex-flex wpex-flex-col';
	} else {
		if ( $has_button && $mobile_stack ) {
			$form_class[] = 'wpex-flex wpex-flex-col wpex-' . $breakpoint . '-flex-row wpex-' . $breakpoint . '-justify-between';
		} else {
			$form_class[] = $has_button ? 'wpex-flex wpex-justify-between' : 'wpex-flex';
		}
	}

	if ( $has_button && $gap ) {
		$form_class[] = vcex_parse_gap_class( $gap );
	}

	$output .= '<form method="get" class="' . esc_attr( implode( ' ', $form_class ) ) . '" action="' . esc_url( home_url( '/' ) ) . '"' . $form_style . '>';

		$input_wrap_class = array(
			'vcex-searchbar-input-wrap',
		);

		if ( ! $input_width ) {
			$input_wrap_class[] = 'wpex-flex-grow';
		}

		if ( $has_clear ) {
			$input_wrap_class[] = 'wpex-relative';
		}

		$output .= '<div class="' . esc_attr( implode( ' ', $input_wrap_class ) ) . '">';

			$output .= '<label>';

				$output .= '<span class="screen-reader-text">' . esc_html( $placeholder ) . '</span>';

				// Input classes.
				$input_class = array(
					'vcex-searchbar-input',
					'wpex-w-100',
					'wpex-inherit-tracking',
					'wpex-inherit-text-transform',
				);

				if ( ! empty( $atts['css'] ) ) {
					$input_class[] = vcex_vc_shortcode_custom_css_class( $atts['css'] );
				}

				// Input style.
				$input_style_args = array(
					'color'         => $atts['input_color'] ?? null,
					'background'    => $atts['input_background_color'] ?? null,
					'border_color'  => $atts['input_border_color'] ?? null,
					'border_width'  => $atts['input_border_width'] ?? null,
					'border_radius' => $atts['input_border_radius'] ?? null,
					'padding'       => $atts['input_padding'] ?? null,
				);

				$input_style = vcex_inline_style( $input_style_args );

				// Input output.
				$input_val = ( $auto_fill && is_search() ) ? get_search_query( false ) : '';
				$output .= '<input value="' . esc_attr( $input_val ) . '" type="search" class="' . esc_attr( implode( ' ', $input_class ) ) . '" name="s" placeholder="' . esc_attr( $placeholder ) . '"' . $input_style . $autofocus . '>';

			$output .= '</label>';

			if ( ! empty( $atts['advanced_query'] ) ) :

				// Sanitize.
				$advanced_query = trim( $atts['advanced_query'] );
				$advanced_query = html_entity_decode( $advanced_query );

				// Convert to array.
				parse_str( $advanced_query, $advanced_query_array );

				// If array is valid loop through params.
				if ( $advanced_query_array ) :

					foreach( $advanced_query_array as $key => $val ) :

						switch ( $val ) {
							case 'current_term':
								if ( is_tax() ) {
									$tax_obj = get_queried_object();
									if ( is_object( $tax_obj ) && ! empty( $tax_obj->taxonomy ) ) {
										$val = $tax_obj->slug;
									}
								}
								break;
							case 'current_author':
								if ( is_author() ) {
									$val = get_the_author_meta( 'ID' );
								}
								break;
						}

						if ( 'current_term' === $val || 'current_author' === $val ) {
							continue;
						}

						$output .= '<input type="hidden" name="' . esc_attr( $key ) . '" value="' . esc_attr( $val ) . '">';

					endforeach;

				endif;

			endif;

			// Clear (x) button
			if ( $has_clear ) {
				wp_enqueue_script( 'vcex-searchbar-clear' );
				$clear_style = vcex_inline_style( array(
					'color' => $atts['input_color'] ?? null,
				) );
				$output .= '<div class="vcex-searchbar-clear vcex-searchbar-clear--hidden wpex-invisible wpex-opacity-0 wpex-cursor-pointer wpex-inherit-color wpex-absolute wpex-right-0 wpex-top-50 -wpex-translate-y-50 wpex-flex wpex-items-center wpex-justify-center wpex-mr-15"' . $clear_style . ' aria-label="' . esc_html__( 'Clear', 'total-theme-core' ) . '" role="button"><svg class="wpex-focus-not-visible-outline-0" focusable="false" xmlns="http://www.w3.org/2000/svg" height="1.2em" viewBox="0 0 24 24" width="1.2em" fill="currentColor" tabindex="0"><path d="M0 0h24v24H0V0z" fill="none"/><path d="M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12 19 6.41z"/></svg></div>';
			}

		$output .= '</div>';

		/*
		 * Button
		 */
		if ( $has_button ) {

			$button_class = array(
				'vcex-searchbar-button',
			);

			if ( ! $button_width ) {
				if ( $mobile_stack ) {
					$button_class[] = 'wpex-' . $breakpoint . '-w-25';
				} else {
					$button_class[] = 'wpex-w-25';
				}
			}

			if ( '100%' === $input_width && '100%' === $button_width ) {
				$button_class[] = 'wpex-py-15';
			} elseif ( $mobile_stack ) {
				$button_class[] = 'wpex-py-15 wpex-' . $breakpoint . '-py-0';
			} else {
				$button_class[] = 'wpex-py-0';
			}

			$button_attrs = array(
				'class' => $button_class,
			);

			// Button hover data.
			$hover_data = array();

			if ( ! empty( $atts['button_bg_hover'] ) ) {
				$hover_data['background'] = esc_attr( vcex_parse_color( $atts['button_bg_hover'] ) );
			}

			if ( ! empty( $atts['button_color_hover'] ) ) {
				$hover_data['color'] = esc_attr( vcex_parse_color( $atts['button_color_hover'] ) );
			}

			if ( $hover_data ) {
				$button_attrs['data-wpex-hover'] = htmlspecialchars( wp_json_encode( $hover_data ) );
			}

			// Button style.
			$button_attrs['style'] = vcex_inline_style( array(
				'background'     => $atts['button_bg'] ?? null,
				'color'          => $atts['button_color'] ?? null,
				'font_size'      => $atts['button_font_size'] ?? null,
				'text_transform' => $atts['button_text_transform'] ?? null,
				'letter_spacing' => $atts['button_letter_spacing'] ?? null,
				'font_weight'    => $atts['button_font_weight'] ?? null,
				'border_radius'  => $atts['button_border_radius'] ?? null,
			), false );

			$output .= '<button' . vcex_parse_html_attributes( $button_attrs ) . '>';

				$output .= do_shortcode( wp_kses_post( str_replace( '``', '"', $button_text ) ) );

			$output .= '</button>';

		} // end has_button check.

	$output .= '</form>';

$output .= '</div>';

if ( ! empty( $atts['wrap_width'] ) && $atts['wrap_float'] && 'center' !== $atts['wrap_float'] ) {
	$output .= '<div class="vcex-clear--searchbar wpex-clear"></div>';
}

echo $output; // @codingStandardsIgnoreLine