<?php
/**
 * vcex_post_media shortcode output.
 *
 * @package Total WordPress Theme
 * @subpackage Total Theme Core
 * @version 1.5
 */

defined( 'ABSPATH' ) || exit;

$atts = vcex_shortcode_atts( 'vcex_post_media', $atts, 'VCEX_Post_Media_Shortcode' );

if ( $atts['supported_media'] && is_string( $atts['supported_media'] ) ) {
	$atts['supported_media'] = wp_parse_list( $atts['supported_media'] );
}

if ( ! is_array( $atts['supported_media'] ) ) {
	$atts['supported_media'] = array(); // must be an array to prevent debug errors.
}

$post_id = vcex_get_the_ID();

$shortcode_class = array(
	'vcex-post-media',
	'vcex-module',
);

if ( ! empty( $atts['width'] ) ) {
	$shortcode_class[] = 'wpex-mx-auto';
	$shortcode_class[] = 'wpex-max-w-100';
}

$extra_classes = vcex_get_shortcode_extra_classes( $atts, 'vcex_post_media' );

if ( $extra_classes ) {
	$shortcode_class = array_merge( $shortcode_class, $extra_classes );
}

$shortcode_class = vcex_parse_shortcode_classes( $shortcode_class, 'vcex_post_media', $atts );

$shortcode_style = vcex_inline_style( array(
	'width'              => $atts['width'] ?? null,
	'animation_delay'    => $atts['animation_delay'] ?? null,
	'animation_duration' => $atts['animation_duration'] ?? null,
), true );

$output = '<div class="' . esc_attr( $shortcode_class ) . '"' . $shortcode_style . '>';

	if ( vcex_is_template_edit_mode() ) {

		if ( function_exists( 'wpex_get_placeholder_image' ) ) {
			$output .= wpex_get_placeholder_image();
		}

	} elseif ( function_exists( 'wpex_get_post_media' ) ) {

		$args = [
			'thumbnail_args'  => [
				'attachment' => get_post_thumbnail_id( $post_id ),
				'size'       => $atts['img_size'] ?? null,
				'crop'       => $atts['img_crop'] ?? null,
				'width'      => $atts['img_width'] ?? null,
				'height'     => $atts['img_height'] ?? null,
				'class'      => 'wpex-align-center' ?? null,
			],
			'lightbox'        => vcex_validate_boolean( $atts['lightbox'] ),
			'supported_media' => $atts['supported_media'],
		];

		if ( isset( $atts['lazy_load'] ) && ! vcex_validate_boolean( $atts['lazy_load'] ) ) {
			$args['thumbnail_args']['lazy'] = false;
		}

		$output .= wpex_get_post_media( $post_id, $args );

	} else {

		$output .= get_the_post_thumbnail();

	}

$output .= '</div>';

// @codingStandardsIgnoreLine
echo $output;