<?php
/**
 * vcex_post_excerpt shortcode output.
 *
 * @package Total WordPress Theme
 * @subpackage Total Theme Core
 * @version 1.5
 */

defined( 'ABSPATH' ) || exit;

$html = '';
$post = get_post( vcex_get_the_ID() );

if ( ! $post ) {
	return;
}

if ( vcex_is_template_edit_mode() ) {
	$excerpt = esc_html( 'This is a sample post excerpt for working in the frontend editor.', 'total-theme-core' );
	if ( ! empty( $atts['length'] ) ) {
		$excerpt = wp_trim_words( $excerpt, $atts['length'] );
	}
} else if ( ! empty( $atts['length'] ) ) {
	$excerpt = vcex_get_excerpt( array(
		'length'  => $atts['length'],
		'context' => 'vcex_post_excerpt',
		'post_id' => vcex_get_the_ID(),
	) );
} else {
	$excerpt = get_the_excerpt( $post );
}

if ( empty( $excerpt ) ) {
	return;
}

$shortcode_class = [
	'vcex-post-excerpt',
	'vcex-module',
	'wpex-last-mb-0',
];

$extra_classes = vcex_get_shortcode_extra_classes( $atts, 'vcex_post_excerpt' );

if ( $extra_classes ) {
	$shortcode_class = array_merge( $shortcode_class, $extra_classes );
}

$shortcode_class = vcex_parse_shortcode_classes( $shortcode_class, 'vcex_post_excerpt', $atts );

$html .= '<div class="' . esc_attr( trim( $shortcode_class ) ) . '">';

	$html .= wpautop( wp_kses_post( $excerpt ) );

$html .= '</div>';

echo $html; // @codingStandardsIgnoreLine