<?php
/**
 * VCEX Countdown.
 *
 * @package Total WordPress Theme
 * @subpackage Total Theme Core
 * @version 1.6.0
 */

defined( 'ABSPATH' ) || exit;

$output = '';
$style  = ! empty( $atts['style'] ) ? $atts['style'] : 'inline';
$items  = ! empty( $atts['items'] ) ? $atts['items'] : [ 'days', 'hours', 'minutes' , 'seconds' ];

if ( is_string( $items ) ) {
	$items = explode( ',', $items );
}

// Get end date data.
$source = $atts['source'] ?? '';
if ( 'custom_field' === $source ) {
	if ( ! empty( $atts['custom_field'] ) ) {
		if ( function_exists( 'get_field' ) ) {
			$date = get_field( $atts['custom_field'] );
		} else {
			$date = get_post_meta( get_the_ID(), $atts['custom_field'], true );
		}
		if ( $date ) {
			$timestamp = strtotime( $date );
			$end_year  = date( 'Y', $timestamp );
			$end_month = date( 'm', $timestamp );
			$end_day   = date( 'd', $timestamp );
			$end_time  = date( 'H:i', $timestamp );
		}
	}
} else {
	$end_year  = ! empty( $atts['end_year'] ) ? intval( do_shortcode( $atts['end_year'] ) ) : date( 'Y' );
	$end_month = ! empty( $atts['end_month'] ) ? intval( $atts['end_month'] ) : 1;
	$end_day   = ! empty( $atts['end_day'] ) ? intval( $atts['end_day'] ) : 1;
	$end_time  = ! empty( $atts['end_time'] ) ? $atts['end_time'] : '00:00';
}

if ( empty( $end_year ) || empty( $end_month ) || empty( $end_day ) ) {
	return;
}

// Sanitize data to make sure input is not crazy.
if ( $end_month > 12 ) {
	$end_month = '';
}
if ( $end_day > 31 ) {
	$end_day = '';
}

// Define end date.
if ( $end_year && $end_month && $end_day ) {
	$end_date = $end_year . '-' . $end_month . '-' . $end_day;
} else {
	$end_date = '2018-12-15';
}

// Add end time.
$end_time = $end_time ?? '00:00'; // sanitize so it's always added.
$end_date = $end_date . ' ' . esc_html( $end_time );

// Make sure date is in correct format.
$end_date = date( 'Y-m-d H:i', strtotime( $end_date ) );

// Countdown data.
$data = [];
$data['data-countdown'] = $end_date;

if ( in_array( 'days', $items ) ) {
	$data['data-days'] = $atts['days'] ?: esc_html__( 'Days', 'total' );
}
if ( in_array( 'hours', $items ) ) {
	$data['data-hours'] = $atts['hours'] ?: esc_html__( 'Hours', 'total' );
}
if ( in_array( 'minutes', $items ) ) {
	$data['data-minutes'] = $atts['minutes'] ?: esc_html__( 'Minutes', 'total' );
}
if ( in_array( 'seconds', $items ) ) {
	$data['data-seconds'] = $atts['seconds'] ?: esc_html__( 'Seconds', 'total' );
}

if ( ! empty( $atts['timezone'] ) ) {
	$data['data-timezone'] = esc_attr( $atts['timezone'] );
}

// Main classes.
$shortcode_class = [
	'vcex-countdown-wrap',
	'vcex-module',
];

$extra_classes = vcex_get_shortcode_extra_classes( $atts, 'vcex_countdown' );

if ( $extra_classes ) {
	$shortcode_class = array_merge( $shortcode_class, $extra_classes );
}

// Add to attributes.
$shortcode_class = vcex_parse_shortcode_classes( $shortcode_class, 'vcex_countdown', $atts );

// Output.
$output .= '<div class="' . esc_attr( $shortcode_class ) . '">';

	$inner_class = [
		'vcex-countdown',
		'vcex-countdown--' . sanitize_html_class( $style ),
	];

	$inner_class_utl = [];

	if ( 'outline' === $style || 'boxed' === $style ) {
		$item_class = [];
		$stack_bk = $atts['stack_breakpoint'] ?? '';
		$inner_class_utl[] = 'wpex-flex';
		if ( $stack_bk ) {
			$inner_class_utl[] = 'wpex-flex-col';
			$inner_class_utl[] = 'wpex-items-center';
			$inner_class_utl[] = 'wpex-' . sanitize_html_class( $stack_bk ) .'-flex-row';
			$inner_class_utl[] = 'wpex-' . sanitize_html_class( $stack_bk ) .'-items-stretch';
		}
		$inner_class_utl[] = 'wpex-flex-wrap';
		$inner_class_utl[] = 'wpex-justify-center';
		$inner_class_utl[] = 'wpex-gap-20';
		if ( empty( $atts['text_align'] ) ) {
			$inner_class_utl[] = 'wpex-text-center';
		}

		$labels_inline = vcex_validate_att_boolean( 'labels_inline', $atts );

		if ( 'outline' === $style || 'boxed' === $style ) {
			$item_class[] = 'wpex-flex';
			if ( $labels_inline ) {
				$item_class[] = 'wpex-flex-row';
				$item_class[] = 'wpex-items-center';
				$item_class[] = 'wpex-gap-5';
			} else {
				$item_class[] = 'wpex-flex-col';
			}
			$item_class[] = 'wpex-justify-center';
		}

		switch ( $style ) {
			case 'outline':
			case 'bordered':
				$item_class[] = 'wpex-bordered';
				break;
			case 'boxed':
				$item_class[] = 'wpex-boxed';
				break;
		}

		if ( vcex_validate_att_boolean( 'stretch_items', $atts ) ) {
			$item_class[] = 'wpex-flex-grow';
			$inner_class[] = 'vcex-countdown--stretch';
		}

		if ( ! empty( $atts['item_shadow'] ) ) {
			$item_class[] = vcex_parse_shadow_class( $atts['item_shadow'] );
		}

		if ( ! empty( $atts['item_width'] ) ) {
			$item_class[] = 'wpex-max-w-100';
		}

		if ( $item_class ) {
			$data['data-item-class'] = implode(' ', array_filter( $item_class ) );
		}
	}

	if ( $inner_class_utl ) {
		$inner_class = array_merge( $inner_class, $inner_class_utl );
	}

	$output .= '<div class="' . esc_attr( implode( ' ', $inner_class ) ) . '"';

		/**
		 * Filters the countdown data attributes.
		 *
		 * @param array $data_attributes
		 */
		$data = (array) apply_filters( 'vcex_countdown_data', $data, $atts );

		foreach ( $data as $name => $value ) {
			$output .= ' ' . $name . '=' . '"' . esc_attr( $value ) . '"';
		}

	$output .= '>';

	$output .='</div>';

$output .= '</div>';

// @codingStandardsIgnoreLine
echo $output;