<?php
/**
 * vcex_breadcrumbs shortcode output.
 *
 * @package Total WordPress Theme
 * @subpackage Total Theme Core
 * @version 1.4.6
 */

defined( 'ABSPATH' ) || exit;

$atts = vcex_shortcode_atts( 'vcex_breadcrumbs', $atts, 'VCEX_Breadcrumbs_Shortcode' );

// Define empty vars.
$crumbs = $aria = $schema = '';

// Custom crumbs check.
$is_custom = false;

// Yoast breadcrumbs.
if ( function_exists( 'yoast_breadcrumb' )
	&& current_theme_supports( 'yoast-seo-breadcrumbs' )
	&& get_theme_mod( 'enable_yoast_breadcrumbs', true )
) {
	$crumbs    = yoast_breadcrumb( '', '', false );
	$is_custom = true;
}

// Custom breadcrumbs.
elseif ( $custom_breadcrumbs = apply_filters( 'wpex_custom_breadcrumbs', null ) ) {
	$crumbs    = wp_kses_post( $custom_breadcrumbs );
	$is_custom = true;
}

// Theme breadcrumbs.
elseif ( class_exists( 'WPEX_Breadcrumbs' ) ) {
	$args = [];
	if ( ! empty( $atts['home_text'] ) ) {
		$args['home_text'] = $atts['home_text'];
	}
	if ( ! empty( $atts['show_parents'] ) ) {
		$args['show_parents'] = vcex_validate_boolean( $atts['show_parents'] );
	}
	if ( ! empty( $atts['first_term_only'] ) ) {
		$args['first_term_only'] = vcex_validate_boolean( $atts['first_term_only'] );
	}
	if ( vcex_vc_is_inline() ) {
		$atts['show_trail_end'] = true; // make sure crumbs always show in the live editor.
	} else if ( ! empty( $atts['show_trail_end'] ) ) {
		$args['show_trail_end'] = vcex_validate_boolean( $atts['show_trail_end'] );
	}
	if ( ! empty( $atts['separator'] ) ) {
		switch ( $atts['separator'] ) {
			case 'dash':
				$args['separator'] = '&ndash;';
			break;
			case 'long_dash':
				$args['separator'] = '&mdash;';
			break;
			case 'dot':
				$args['separator'] = '&middot;';
			break;
			case 'arrow':
				$args['separator'] = is_rtl() ? '&larr;' : '&rarr;';
			break;
			case 'double_arrow':
				$args['separator'] = is_rtl() ? '&laquo;' : '&raquo;';
			break;
			case 'forward_slash':
				$args['separator'] = '&sol;';
			break;
			case 'backslash':
				$args['separator'] = '&bsol;';
			break;
			case 'pipe':
				$args['separator'] = '&vert;';
			break;
			case 'angle':
				$icon = is_rtl() ? 'angle-left' : 'angle-right';
				$args['separator'] = do_shortcode( '[ticon icon="' . $icon . '"]' );
			break;
		}
	}
	$crumbs = new WPEX_Breadcrumbs( $args );
	$crumbs = $crumbs->generate_crumbs(); // needs to generate it's own to prevent issues with theme stuff.
}

// Return if no crumbs.
if ( ! $crumbs ) {
	return;
}

// Shortcode classes.
$shortcode_class = [
	'vcex-breadcrumbs',
];

if ( empty( $atts['link_color'] ) && vcex_validate_att_boolean( 'link_inherit_color', $atts, true ) ) {
	$shortcode_class[] = 'vcex-breadcrumbs--links-inherit-color';
}

if ( ! empty( $atts['color'] ) ) {
	$shortcode_class[] = 'vcex-breadcrumbs--custom-color';
}

if ( ! empty( $atts['font_style'] ) && 'italic' === $atts['font_style'] ) {
	$shortcode_class[] = 'wpex-italic';
}

// Responsive settings.
$unique_classname = vcex_element_unique_classname();

$el_responsive_styles = [
	'font_size' => $atts['font_size'],
];

$responsive_css = vcex_element_responsive_css( $el_responsive_styles, $unique_classname );

if ( $responsive_css ) {
	$shortcode_class[] = $unique_classname;
	echo '<style>' . $responsive_css . '</style>';
}

$extra_classes = vcex_get_shortcode_extra_classes( $atts, 'vcex_breadcrumbs' );

if ( $extra_classes ) {
	$shortcode_class = array_merge( $shortcode_class, $extra_classes );
}

$shortcode_class = vcex_parse_shortcode_classes( $shortcode_class, 'vcex_breadcrumbs', $atts );

// Get inline styles.
$shortcode_css_args = [
	'color'                         => $atts['color'] ?? null,
	'--wpex-link-color'             => $atts['link_color'] ?? null,
	'--wpex-hover-link-color'       => $atts['link_color_hover'] ?? null,
	'--vcex-breadcrumbs-sep-color'  => $atts['separator_color'] ?? null,
	'--vcex-breadcrumbs-sep-margin' => $atts['separator_margin'] ?? null,
	'font_size'                     => $atts['font_size'] ?? null,
	'font_family'                   => $atts['font_family'] ?? null,
	'text_align'                    => $atts['align'] ?? null,
	'line_height'                   => $atts['line_height'] ?? null,
	'letter_spacing'                => $atts['letter_spacing'] ?? null,
	'background_color'              => $atts['background_color'] ?? null,
	'border_color'                  => $atts['border_color'] ?? null,
	'animation_delay'               => $atts['animation_delay'] ?? null,
	'animation_duration'            => $atts['animation_duration'] ?? null,
];

if ( ! empty( $atts['link_underline'] ) ) {
	$underline = vcex_validate_boolean( $atts['link_underline'] );
	$shortcode_css_args['--wpex-link-text-decoration'] = $underline ? 'underline' : 'none';
}

if ( ! empty( $atts['link_underline_hover'] ) ) {
	$underline = vcex_validate_boolean( $atts['link_underline_hover'] );
	$shortcode_css_args['--wpex-hover-link-text-decoration'] = $underline ? 'underline' : 'none';
}

$shortcode_css = vcex_inline_style( $shortcode_css_args, false );

// Define wrap attributes
$shortcode_attrs = [
	'class' => $shortcode_class,
	'style' => $shortcode_css,
];

// Get aria tag.
if ( class_exists( 'TotalTheme\\Accessibility\\Aria_Landmark' ) ) {
	$aria_landmark = new TotalTheme\Accessibility\Aria_Landmark( 'breadcrumbs' );
	ob_start();
		$aria_landmark->render();
	$aria = ob_get_clean();
}

if ( ! $is_custom ) {
	$schema = ' itemscope itemtype="http://schema.org/BreadcrumbList"';
}

// Display breadcrumbs.
echo '<nav' . vcex_parse_html_attributes( $shortcode_attrs ) . $aria . $schema . '>' . $crumbs . '</nav>';