<?php
defined( 'ABSPATH' ) || exit;

/**
 * WooCommerce Template Shortcode.
 *
 * @package TotalThemeCore
 * @version 1.4.6
 */
if ( ! class_exists( 'Vcex_WooCommerce_Content' ) ) {

	class Vcex_WooCommerce_Content {

		/**
		 * Shortcode tag.
		 */
		const TAG = 'vcex_woocommerce_content';

		/**
		 * Main constructor.
		 */
		public function __construct() {
			add_shortcode( self::TAG, __CLASS__ . '::output' );

			if ( function_exists( 'vc_lean_map' ) ) {
				new \TotalThemeCore\Vcex\WPBakery\Map\WooCommerce_Content;
			}
		}

		/**
		 * Get shortcode title.
		 */
		public static function get_title() {
			return esc_html__( 'WooCommerce Content', 'total' );
		}

		/**
		 * Shortcode output => Get template file and display shortcode.
		 */
		public static function output( $atts = false ) {
			if ( ! vcex_maybe_display_shortcode( self::TAG, $atts ) || ! function_exists( 'is_woocommerce' ) || ! function_exists( 'woocommerce_content' ) ) {
				return;
			}
			if ( vcex_is_template_edit_mode() ) {
				return '<div class="wpex-surface-3 wpex-text-2 wpex-p-15 wpex-text-center">' . esc_html__( 'This element is disabled in the frontend editor to prevent an endless loop.', 'total-theme-core' ) .'</div>';
			} else {
				ob_start();
					woocommerce_content();
				return ob_get_clean();
			}
		}

		/**
		 * Array of shortcode parameters.
		 */
		public static function get_params() {
			$params = array(
				array(
					'type' => 'vcex_notice',
					'param_name' => 'main_notice',
					'text' => esc_html__( 'This element should be used only when creating dynamic templates and it display the current page/archive WooCommerce output. This element displays the output of the woocommerce_content function, aka the woocommerce.php file.', 'total-theme-core' ),
				),
			);
			return (array) apply_filters( 'vcex_shortcode_params', $params, self::TAG );
		}

	}

}
new Vcex_WooCommerce_Content;

if ( class_exists( 'WPBakeryShortCode' ) && ! class_exists( 'WPBakeryShortCode_Vcex_WooCommerce_Content' ) ) {
	class WPBakeryShortCode_Vcex_WooCommerce_Content extends WPBakeryShortCode {}
}