<?php
defined( 'ABSPATH' ) || exit;

use TotalThemeCore\Vcex\Ajax;

/**
 * Navbar Shortcode.
 *
 * @package TotalThemeCore
 * @version 1.5.1
 */
if ( ! class_exists( 'Vcex_Navbar_Shortcode' ) ) {

	class Vcex_Navbar_Shortcode {

		/**
		 * Shortcode tag.
		 */
		const TAG = 'vcex_navbar';

		/**
		 * Main constructor.
		 */
		public function __construct() {
			add_shortcode( self::TAG, [ __CLASS__, 'output' ] );

			if ( function_exists( 'vc_lean_map' ) ) {
				new \TotalThemeCore\Vcex\WPBakery\Map\Navbar;
			}
		}

		/**
		 * Shortcode title.
		 */
		public static function get_title() {
			return esc_html__( 'Navigation Bar', 'total-theme-core' );
		}

		/**
		 * Shortcode output => Get template file and display shortcode.
		 */
		public static function output( $atts, $content = null ) {
			if ( ! vcex_maybe_display_shortcode( self::TAG, $atts ) ) {
				return;
			}
			$atts = vcex_shortcode_atts( self::TAG, $atts, __CLASS__ );
			self::enqueue_scripts( $atts );
			ob_start();
			$shortcode_css = new TotalThemeCore\Vcex\Shortcode_CSS( __CLASS__, $atts );
			if ( $shortcode_css->render_style() ) {
				$atts['vcex_class'] = $shortcode_css->unique_classname;
			}
			do_action( 'vcex_shortcode_before', self::TAG, $atts );
			include vcex_get_shortcode_template( self::TAG );
			do_action( 'vcex_shortcode_after', self::TAG, $atts );
			return ob_get_clean();
		}

		/**
		 * Array of shortcode parameters.
		 */
		public static function get_params() {
			$params = array(
				// General
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Aria Label', 'total-theme-core' ),
					'param_name' => 'aria_label',
					'description' => esc_html__( 'Optional menu description for screen readers.', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_ofswitch',
					'std' => 'false',
					'heading' => esc_html__( 'Show Select Field on Mobile?', 'total-theme-core' ),
					'param_name' => 'mobile_select',
					'description' => esc_html__( 'When enabled the menu buttons will be converted into a singular select dropdown on mobile devices.', 'total-theme-core' ),
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Mobile Select Empty Option Text', 'total-theme-core' ),
					'param_name' => 'mobile_select_browse_txt',
					'description' => esc_html__( 'This option is used as the first option in the mobile select field. For example if you have a standard link based menu you may use "Browse" as the empty option text. If you have setup a filter style menu you may want to keep this empty and add an "All" link at the start of your menu which is done by adding a link with a # symbol as the url value.', 'total-theme-core' ),
					'dependency' => array( 'element' => 'mobile_select', 'value' => 'true' ),
				),
				array(
					'type' => 'vcex_select',
					'heading' => esc_html__( 'Visibility', 'total-theme-core' ),
					'param_name' => 'visibility',
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Element ID', 'total-theme-core' ),
					'param_name' => 'unique_id',
					'admin_label' => true,
					'description' => vcex_shortcode_param_description( 'unique_id' ),
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Extra class name', 'total-theme-core' ),
					'description' => vcex_shortcode_param_description( 'el_class' ),
					'param_name' => 'classes',
				),
				vcex_vc_map_add_css_animation(),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Animation Duration', 'total'),
					'param_name' => 'animation_duration',
					'css' => true,
					'description' => esc_html__( 'Enter your custom time in seconds (decimals allowed).', 'total'),
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Animation Delay', 'total'),
					'param_name' => 'animation_delay',
					'css' => true,
					'description' => esc_html__( 'Enter your custom time in seconds (decimals allowed).', 'total'),
				),
				// Menu
				array(
					'type' => 'vcex_menus_select',
					'admin_label' => true,
					'heading' => esc_html__( 'Menu', 'total-theme-core' ),
					'param_name' => 'menu',
					'save_always' => true,
					'group' => esc_html__( 'Menu', 'total-theme-core' ),
				),
				array(
					'type' => 'autocomplete',
					'heading' => esc_html__( 'Taxonomy Name', 'total-theme-core' ),
					'param_name' => 'taxonomy',
					'settings' => array(
						'multiple' => false,
						'min_length' => 1,
						'groups' => false,
						'display_inline' => true,
						'delay' => 0,
					),
					'group' => esc_html__( 'Menu', 'total-theme-core' ),
					'dependency' => array( 'element' => 'menu', 'value' => 'dynamic_terms' ),
				),
				array(
					'type' => 'autocomplete',
					'heading' => esc_html__( 'Child Of', 'total-theme-core' ),
					'param_name' => 'child_of',
					'settings' => array(
						'multiple' => false,
						'min_length' => 1,
						'groups' => true,
						'display_inline' => true,
					//	'delay' => 0,
						'auto_focus' => true,
					),
					'group' => esc_html__( 'Menu', 'total-theme-core' ),
					'dependency' => array( 'element' => 'menu', 'value' => 'dynamic_terms' ),
				),
				array(
					'type' => 'autocomplete',
					'heading' => esc_html__( 'Exclude Terms', 'total-theme-core' ),
					'param_name' => 'terms_not_in',
					'settings' => [
						'multiple' => true,
						'min_length' => 1,
						'groups' => true,
						'display_inline' => true,
					//	'delay' => 0,
					],
					/*'elementor' => [
						'type' => 'text',
						'label_block' => true,
						'description' => esc_html__( 'Enter a comma separated list of taxonomy term ids.', 'total-theme-core' ),
					],*/
					'group' => esc_html__( 'Menu', 'total-theme-core' ),
					'dependency' => array( 'element' => 'menu', 'value' => 'dynamic_terms' ),
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Post Filter Grid ID', 'total-theme-core' ),
					'param_name' => 'filter_menu',
					'description' => esc_html__( 'Enter the "Element ID" of the post grid module you wish to filter. This will only work on the theme specific grids. Make sure the filter on the grid module is disabled to prevent conflicts. View theme docs for more info.', 'total-theme-core' ),
					'group' => esc_html__( 'Menu', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_ofswitch',
					'std' => 'false',
					'heading' => esc_html__( 'Local Scroll menu', 'total-theme-core'),
					'param_name' => 'local_scroll',
					'group' => esc_html__( 'Menu', 'total-theme-core' ),
				),
				// Filter
				array(
					'type' => 'vcex_select',
					'heading' => esc_html__( 'Filter Mode', 'total-theme-core' ),
					'param_name' => 'filter_layout_mode',
					'std' => 'masonry',
					'choices' => [
						'masonry' => esc_html__( 'Isotope: Masonry (sorts visible items)', 'total-theme-core' ),
						'fitRows' => esc_html__( 'Isotope: Fit Rows (sorts visible items)', 'total-theme-core' ),
						'hide' => esc_html__( 'Simple Show/Hide (sorts visible items)', 'total-theme-core' ),
						'ajax' => esc_html__( 'Ajaxed (loads selected items - Post Cards only)', 'total-theme-core' ),
					],
					'description' => esc_html__( 'Note: The Isotope layouts will not work with the Post Cards "Modern CSS Grid" layout.', 'total-theme-core' ),
					'group' => esc_html__( 'Filter', 'total-theme-core' ),
					'dependency' => array( 'element' => 'filter_menu', 'not_empty' => true ),
				),
				array(
					'type' => 'vcex_select',
					'heading' => esc_html__( 'Filter Query Type', 'total-theme-core' ),
					'param_name' => 'filter_relation',
					'choices' => [
						'' => esc_html__( 'Single Selection', 'total-theme-core' ),
						'AND' => esc_html__( 'Multiple AND Selections', 'total-theme-core' ),
						'OR' => esc_html__( 'Multiple OR Selections', 'total-theme-core' ),
					],
					'group' => esc_html__( 'Filter', 'total-theme-core' ),
					'dependency' => array( 'element' => 'filter_layout_mode', 'value' => 'ajax' ),
				),
				array(
					'type' => 'autocomplete',
					'heading' => esc_html__( 'Active Term', 'total-theme-core' ),
					'param_name' => 'filter_active_item',
					'settings' => array(
						'multiple' => true,
						'min_length' => 1,
						'groups' => true,
						'display_inline' => true,
					//	'delay' => 0,
						'auto_focus' => true,
					),
					'description' => esc_html__( 'Select the term you wish to have active by default. If using the AJAX filter this value should match the default term selected in the targeted Post Cards element via the "Include Terms" field.', 'total-theme-core' ),
					'group' => esc_html__( 'Filter', 'total-theme-core' ),
					'dependency' => array( 'element' => 'filter_menu', 'not_empty' => true ),
				),
				array(
					'type' => 'vcex_ofswitch',
					'std' => 'false',
					'heading' => esc_html__( 'Show Term Count', 'total-theme-core' ),
					'param_name' => 'term_count',
					'description' => esc_html__( 'Enable to display the number of posts assigned to a given taxonomy term item. Note: Since this element exists independently from the target grid, this functionality must use AJAX to calculate how many posts are inside each term so it may take a second for the terms to show up on page load and it will only display on the live site.', 'total-theme-core' ),
					'group' => esc_html__( 'Filter', 'total-theme-core' ),
					'dependency' => array( 'element' => 'filter_layout_mode', 'value' => 'ajax' ),
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Custom All Text', 'total-theme-core' ),
					'param_name' => 'all_text',
					'group' => esc_html__( 'Filter', 'total-theme-core' ),
					'description' => esc_html__( 'The "All" button is added when displaying a taxonomy based menu.', 'total-theme-core' ),
					'dependency' => array( 'element' => 'filter_menu', 'not_empty' => true ),
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Custom Filter Speed', 'total-theme-core' ),
					'param_name' => 'filter_transition_duration',
					'description' => esc_html__( 'Default is "0.4" seconds. Enter "0.0" to disable.', 'total-theme-core' ),
					'group' => esc_html__( 'Filter', 'total-theme-core' ),
					'dependency' => array( 'element' => 'filter_layout_mode', 'value' => [ 'masonry', 'fitRows' ] ),
				),
				// Style
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Bottom Margin', 'total-theme-core' ),
					'param_name' => 'bottom_margin',
					'value' => vcex_margin_choices(),
					'admin_label' => true,
					'group' => esc_html__( 'Style', 'total-theme-core' ),
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Preset', 'total-theme-core' ),
					'param_name' => 'preset_design',
					'std' => 'none',
					'value' => array(
						esc_html__( 'None', 'total-theme-core' ) => 'none',
						esc_html__( 'Dark', 'total-theme-core' ) => 'dark',
					),
					'group' => esc_html__( 'Style', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_ofswitch',
					'heading' => esc_html__( 'Expand Links', 'total-theme-core' ),
					'param_name' => 'expand_links',
					'std' => 'false',
					'group' => esc_html__( 'Style', 'total-theme-core' ),
					'dependency' => array( 'element' => 'button_layout', 'value' => 'spaced_out' ),
				),
				array(
					'type' => 'vcex_text_alignments',
					'heading' => esc_html__( 'Alignment', 'total-theme-core' ),
					'param_name' => 'align',
					'group' => esc_html__( 'Style', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_select_buttons',
					'heading' => esc_html__( 'Layout', 'total-theme-core' ),
					'param_name' => 'button_layout',
					'std' => '',
					'choices' => array(
						'' => esc_html__( 'Default', 'total-theme-core' ),
						'spaced_out' => esc_html__( 'Spaced Out', 'total-theme-core' ),
						'list' => esc_html__( 'List', 'total-theme-core' ),
						'expanded' => esc_html__( 'Expanded', 'total-theme-core' ),
					),
					'group' => esc_html__( 'Style', 'total-theme-core' ),
					'dependency' => array( 'element' => 'preset_design', 'value' => 'none' ),
				),
				array(
					'type' => 'vcex_ofswitch',
					'std' => 'false',
					'heading' => esc_html__( 'Full-Screen Center', 'total-theme-core'),
					'param_name' => 'full_screen_center',
					'description' => esc_html__( 'Center the navigation when used inside a stretched row or full-screen page layout.', 'total-theme-core' ),
					'group' => esc_html__( 'Style', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_colorpicker',
					'heading' => esc_html__( 'Menu Background', 'total-theme-core' ),
					'param_name' => 'wrap_background',
					'css' => [
						'selector' => '{{WRAPPER}}',
						'property' => 'background',
					],
					'group' => esc_html__( 'Style', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_subheading',
					'param_name' => 'vcex_subheading__links',
					'text' => esc_html__( 'Link Styles', 'total-theme-core' ),
					'group' => esc_html__( 'Style', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_hover_animations',
					'heading' => esc_html__( 'Hover Animation', 'total-theme-core'),
					'param_name' => 'hover_animation',
					'group' => esc_html__( 'Style', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_button_styles',
					'heading' => esc_html__( 'Button Style', 'total-theme-core' ),
					'param_name' => 'button_style',
					'group' => esc_html__( 'Style', 'total-theme-core' ),
					'std' => 'minimal-border',
					'dependency' => array( 'element' => 'preset_design', 'value' => 'none' ),
				),
				array(
					'type' => 'vcex_select_buttons',
					'heading' => esc_html__( 'Link Underline', 'total-theme-core' ),
					'param_name' => 'link_underline',
					'choices' => array(
						'' => esc_html__( 'Default', 'total-theme-core' ),
						'underline' => esc_html__( 'Underline', 'total-theme-core' ),
						'none' => esc_html__( 'No underline', 'total-theme-core' ),
					),
					'css' => [
						'selector' => '.vcex-navbar-link',
						'property' => 'text-decoration',
					],
					'dependency' => array( 'element' => 'button_style', 'value' => 'plain-text' ),
					'group' => esc_html__( 'Style', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_select_buttons',
					'heading' => esc_html__( 'Link Underline: Hover', 'total-theme-core' ),
					'param_name' => 'link_underline_hover',
					'choices' => array(
						'' => esc_html__( 'Default', 'total-theme-core' ),
						'underline' => esc_html__( 'Underline', 'total-theme-core' ),
						'none' => esc_html__( 'No underline', 'total-theme-core' ),
					),
					'css' => [
						'selector' => '.vcex-navbar-link:hover',
						'property' => 'text-decoration',
					],
					'dependency' => array( 'element' => 'button_style', 'value' => 'plain-text' ),
					'group' => esc_html__( 'Style', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_select_buttons',
					'heading' => esc_html__( 'Link Underline: Active', 'total-theme-core' ),
					'param_name' => 'link_underline_active',
					'choices' => array(
						'' => esc_html__( 'Default', 'total-theme-core' ),
						'underline' => esc_html__( 'Underline', 'total-theme-core' ),
						'none' => esc_html__( 'No underline', 'total-theme-core' ),
					),
					'css' => [
						'selector' => [
							'.vcex-navbar-link:active',
							'.vcex-navbar-link.active',
						],
						'property' => 'text-decoration',
					],
					'dependency' => array( 'element' => 'button_style', 'value' => 'plain-text' ),
					'group' => esc_html__( 'Style', 'total-theme-core' ),
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Border Radius', 'total-theme-core' ),
					'param_name' => 'border_radius',
					'value' => vcex_border_radius_choices(),
					'group' => esc_html__( 'Style', 'total-theme-core' ),
					'dependency' => array( 'element' => 'preset_design', 'value' => 'none' ),
				),
				array(
					'type' => 'vcex_button_colors',
					'heading' => esc_html__( 'Button Color', 'total-theme-core' ),
					'param_name' => 'button_color',
					'group' => esc_html__( 'Style', 'total-theme-core' ),
					'dependency' => array( 'element' => 'preset_design', 'value' => 'none' ),
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Link Side Margin', 'total-theme-core' ),
					'param_name' => 'link_margin_side',
					'value' => vcex_margin_choices(),
					'group' => esc_html__( 'Style', 'total-theme-core' ),
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Link Bottom Margin', 'total-theme-core' ),
					'param_name' => 'link_margin_bottom',
					'value' => vcex_margin_choices(),
					'group' => esc_html__( 'Style', 'total-theme-core' ),
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Link Padding', 'total-theme-core' ),
					'param_name' => 'link_padding',
					'css' => [
						'selector' => 'a.vcex-navbar-link',
						'property' => 'padding',
					],
					'value' => vcex_padding_choices(),
					'group' => esc_html__( 'Style', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_colorpicker',
					'heading' => esc_html__( 'Color', 'total-theme-core' ),
					'param_name' => 'color',
					'css' => [
						'selector' => 'a.vcex-navbar-link',
					],
					'group' => esc_html__( 'Style', 'total-theme-core' ),
					'dependency' => array( 'element' => 'preset_design', 'value' => 'none' ),
				),
				array(
					'type' => 'vcex_colorpicker',
					'heading' => esc_html__( 'Background', 'total-theme-core' ),
					'param_name' => 'background',
					'css' => [
						'selector' => 'a.vcex-navbar-link',
					],
					'group' => esc_html__( 'Style', 'total-theme-core' ),
					'dependency' => array( 'element' => 'preset_design', 'value' => 'none' ),
				),
				array(
					'type' => 'vcex_colorpicker',
					'heading' => esc_html__( 'Color: Hover', 'total-theme-core' ),
					'param_name' => 'hover_color',
					'css' => [
						'selector' => [
							'a.vcex-navbar-link:hover',
							'a.vcex-navbar-link.active'
						],
						'property' => 'color',
					],
					'group' => esc_html__( 'Style', 'total-theme-core' ),
					'dependency' => array( 'element' => 'preset_design', 'value' => 'none' ),
				),
				array(
					'type' => 'vcex_colorpicker',
					'heading' => esc_html__( 'Color: Active', 'total-theme-core' ),
					'param_name' => 'active_color',
					'css' => [
						'selector' => [
							'a.vcex-navbar-link:active',
							'a.vcex-navbar-link.active'
						],
						'property' => 'color',
					],
					'group' => esc_html__( 'Style', 'total-theme-core' ),
					'dependency' => array( 'element' => 'preset_design', 'value' => 'none' ),
				),
				array(
					'type' => 'vcex_colorpicker',
					'heading' => esc_html__( 'Background: Hover', 'total-theme-core' ),
					'param_name' => 'hover_bg',
					'css' => [
						'selector' => [
							'a.vcex-navbar-link:hover',
							'a.vcex-navbar-link.active'
						],
						'property' => 'background',
					],
					'group' => esc_html__( 'Style', 'total-theme-core' ),
					'dependency' => array( 'element' => 'preset_design', 'value' => 'none' ),
				),
				array(
					'type' => 'vcex_colorpicker',
					'heading' => esc_html__( 'Background: Active', 'total-theme-core' ),
					'param_name' => 'active_bg',
					'css' => [
						'selector' => [
							'a.vcex-navbar-link:active',
							'a.vcex-navbar-link.active'
						],
						'property' => 'background',
					],
					'group' => esc_html__( 'Style', 'total-theme-core' ),
					'dependency' => array( 'element' => 'preset_design', 'value' => 'none' ),
				),
				// Typography
				array(
					'type' => 'vcex_font_family_select',
					'heading' => esc_html__( 'Font Family', 'total-theme-core' ),
					'param_name' => 'font_family',
					'css' => [
						'selector' => 'a.vcex-navbar-link',
					],
					'group' => esc_html__( 'Typography', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_select',
					'heading' => esc_html__( 'Font Weight', 'total-theme-core' ),
					'param_name' => 'font_weight',
					// note: adds utility class instead of css
					'group' => esc_html__( 'Typography', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_font_size',
					'heading' => esc_html__( 'Font Size', 'total-theme-core' ),
					'param_name' => 'font_size',
					'css' => true,
					'group' => esc_html__( 'Typography', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_preset_textfield',
					'heading' => esc_html__( 'Line Height', 'total-theme-core' ),
					'param_name' => 'line_height',
					'choices' => 'line_height',
					'css' => [
						'selector' => 'a.vcex-navbar-link',
					],
					'group' => esc_html__( 'Typography', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_preset_textfield',
					'heading' => esc_html__( 'Letter Spacing', 'total-theme-core' ),
					'param_name' => 'letter_spacing',
					'choices' => 'letter_spacing',
					'css' => [
						'selector' => 'a.vcex-navbar-link',
					],
					'group' => esc_html__( 'Typography', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_select',
					'heading' => esc_html__( 'Text Transform', 'total-theme-core' ),
					'param_name' => 'text_transform',
					'css' => [
						'selector' => 'a.vcex-navbar-link',
					],
					'group' => esc_html__( 'Typography', 'total-theme-core' ),
				),
				// Sticky.
				array(
					'type' => 'vcex_ofswitch',
					'std' => 'false',
					'heading' => esc_html__( 'Sticky', 'total-theme-core'),
					'param_name' => 'sticky',
					'group' => esc_html__( 'Sticky', 'total-theme-core' ),
					'description' => esc_html__( 'Note: Sticky is disabled in the front-end editor.', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_colorpicker',
					'heading' => esc_html__( 'Sticky Background', 'total-theme-core'),
					'param_name' => 'sticky_background',
					'css' => [
						'selector' => '.is-sticky > {{WRAPPER}}',
						'property' => 'background-color',
						'important' => true,
					],
					'dependency' => array( 'element' => 'sticky', 'value' => 'true' ),
					'group' => esc_html__( 'Sticky', 'total-theme-core' ),
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Sticky Endpoint', 'total-theme-core'),
					'param_name' => 'sticky_endpoint',
					'group' => esc_html__( 'Sticky', 'total-theme-core' ),
					'description' => esc_html__( 'Enter the ID or classname of an element that when reached will disable the stickiness. Example: #footer', 'total-theme-core' ),
					'dependency' => array( 'element' => 'sticky', 'value' => 'true' ),
				),
				array(
					'type' => 'vcex_ofswitch',
					'std' => 'true',
					'heading' => esc_html__( 'Offset Navbar Height', 'total-theme-core'),
					'param_name' => 'sticky_offset_nav_height',
					'group' => esc_html__( 'Sticky', 'total-theme-core' ),
					'dependency' => array( 'element' => 'sticky', 'value' => 'true' ),
					'description' => esc_html__( 'Whether the navigation menu height should be included in the offset when calculating local scroll position. Generally you would enable for horizontal menus and disable for vertical menus (for example if the menu is placed in a sidebar).', 'total-theme-core' ),
				),
				// CSS
				array(
					'type' => 'css_editor',
					'heading' => esc_html__( 'Link CSS', 'total-theme-core' ),
					'param_name' => 'css',
					'group' => esc_html__( 'Link CSS', 'total-theme-core' ),
					'dependency' => array( 'element' => 'preset_design', 'value' => 'none' ),
				),
				array(
					'type' => 'css_editor',
					'heading' => esc_html__( 'Wrap CSS', 'total-theme-core' ),
					'param_name' => 'wrap_css',
					'group' => esc_html__( 'Wrap CSS', 'total-theme-core' ),
				),
				// Deprecated params
				array( 'type' => 'hidden', 'param_name' => 'style' ),
			);

			return (array) apply_filters( 'vcex_shortcode_params', $params, self::TAG );
		}

		/**
		 * Parses deprecated attributes.
		 */
		public static function parse_deprecated_attributes( $atts = [] ) {
			if ( empty( $atts ) || ! is_array( $atts ) ) {
				return $atts;
			}
			if ( isset( $atts['style'] ) && 'simple' === $atts['style'] ) {
				$atts['button_style'] = 'plain-text';
				unset( $atts['style'] );
			}
			return $atts;
		}

		/**
		 * Enqueue scripts.
		 */
		public static function enqueue_scripts( $atts = [] ) {
			if ( ! empty( $atts['filter_menu'] ) ) {
				$filter_mode = ! empty( $atts['filter_layout_mode'] ) ? $atts['filter_layout_mode'] : 'masonry';
				switch ( $filter_mode ) {
					case 'ajax':
						Ajax::instance()->enqueue_scripts( __CLASS__, $atts );
						break;
					case 'hide':
						wp_enqueue_script(
							'vcex-navbar-filter',
							vcex_asset_url( 'js/shortcodes/vcex-navbar-filter.min.js' ),
							[],
							TTC_VERSION,
							true
						);
						break;
					case 'masonry':
					case 'fitRows':
					default:
						vcex_enqueue_isotope_scripts();
						wp_enqueue_script(
							'vcex-navbar_filter-links',
							vcex_asset_url( 'js/shortcodes/vcex-navbar-filter-isotope.min.js' ),
							[ 'jquery', 'imagesloaded', 'isotope' ],
							TTC_VERSION,
							true
						);
						break;
				}
			}
			if ( vcex_validate_att_boolean( 'sticky', $atts, false ) ) {
				wp_enqueue_script(
					'vcex-navbar_sticky',
					vcex_asset_url( 'js/shortcodes/vcex-navbar_sticky.min.js' ),
					[],
					TTC_VERSION,
					true
				);
			}
			if ( vcex_validate_att_boolean( 'mobile_select', $atts, false ) ) {
				wp_enqueue_script(
					'vcex-navbar_mobile-select',
					vcex_asset_url( 'js/shortcodes/vcex-navbar_mobile-select.min.js' ),
					[],
					TTC_VERSION,
					true
				);
			}
		}

		/**
		 * Loops through the result of get_terms to return menu items.
		 */
		public static function get_menu_items_from_terms( $args = [], $atts = [] ) {
			/**
			 * Filters the navigation bar element get_terms arguments.
			 *
			 * @param array $args
			 */
			$args = (array) apply_filters( 'vcex_navbar_get_terms_args', $args, $atts );

			$terms = get_terms( $args );

			if ( ! is_array( $terms ) || ! count( $terms ) || is_wp_error( $terms ) ) {
				return;
			}

			$menu_items = [];

			if ( ! empty( $atts['filter_menu'] )
				&& empty( $atts['filter_active_item'] )
			) {
				$menu_item          = new stdClass();
				$menu_item->url     = '#';
				$menu_item->title   = ! empty( $atts['all_text'] ) ? sanitize_text_field( $atts['all_text'] ) : esc_html__( 'All', 'total' );
				$menu_item->classes = [ 'vcex-navbar__all-link' ];
				$menu_items[]       = $menu_item;
			}

			foreach ( $terms as $term ) {
				$menu_item             = new stdClass();
				$menu_item->url        = get_term_link( $term, $args['taxonomy'] );
				$menu_item->title      = $term->name;
				$menu_item->type       = 'taxonomy';
				$menu_item->object     = $args['taxonomy'];
				$menu_item->object_id  = $term->term_id;
				$menu_item->term_count = $term->count ?? 0;
				$menu_items[]          = $menu_item;
			}

			return $menu_items;
		}

	}

}
new Vcex_Navbar_Shortcode;

if ( class_exists( 'WPBakeryShortCode' ) && ! class_exists( 'WPBakeryShortCode_Vcex_Navbar' ) ) {
	class WPBakeryShortCode_Vcex_Navbar extends WPBakeryShortCode {}
}