<?php
defined( 'ABSPATH' ) || exit;

/**
 * Countdown Shortcode.
 *
 * @package TotalThemeCore
 * @version 1.6.1
 */
if ( ! class_exists( 'VCEX_Countdown_Shortcode' ) ) {

	class VCEX_Countdown_Shortcode {

		/**
		 * Shortcode tag.
		 */
		const TAG = 'vcex_countdown';

		/**
		 * Main constructor.
		 */
		public function __construct() {
			add_shortcode( self::TAG, [ __CLASS__, 'output'] );

			if ( function_exists( 'vc_lean_map' ) ) {
				new \TotalThemeCore\Vcex\WPBakery\Map\Countdown;
			}
		}

		/**
		 * Shortcode title.
		 */
		public static function get_title() {
			return esc_html__( 'Countdown', 'total-theme-core' );
		}

		/**
		 * Shortcode output => Get template file and display shortcode.
		 */
		public static function output( $atts, $content = null ) {
			if ( ! vcex_maybe_display_shortcode( self::TAG, $atts ) ) {
				return;
			}
			self::enqueue_scripts( $atts );
			$atts = vcex_shortcode_atts( self::TAG, $atts, __CLASS__ );
			ob_start();
			do_action( 'vcex_shortcode_before', self::TAG, $atts );
			$shortcode_css = new TotalThemeCore\Vcex\Shortcode_CSS( __CLASS__, $atts );
			if ( $shortcode_css->render_style() ) {
				$atts['vcex_class'] = $shortcode_css->unique_classname;
			}
			include vcex_get_shortcode_template( self::TAG );
			do_action( 'vcex_shortcode_after', self::TAG, $atts );
			return ob_get_clean();
		}

		/**
		 * Enqueue scripts.
		 */
		protected static function enqueue_scripts( $atts ) {
			wp_enqueue_script(
				'countdown',
				vcex_asset_url( 'js/lib/countdown.min.js' ),
				array( 'jquery' ),
				'2.1.0',
				true
			);

			wp_enqueue_script(
				'vcex-countdown',
				vcex_asset_url( 'js/shortcodes/vcex-countdown.min.js' ),
				array( 'jquery', 'countdown' ),
				TTC_VERSION,
				true
			);

			if ( vcex_vc_is_inline() || ! empty( $atts['timezone'] ) ) {

				wp_enqueue_script(
					'moment-with-locales',
					vcex_asset_url( 'js/lib/moment-with-locales.min.js' ),
					array( 'jquery' ),
					'2.10.0',
					true
				);

				wp_enqueue_script(
					'moment-timezone-with-data',
					vcex_asset_url( 'js/lib/moment-timezone-with-data.min.js' ),
					array( 'jquery' ),
					'2.10.0',
					true
				);

			}
		}

		/**
		 * Array of shortcode parameters.
		 */
		public static function get_params() {
			$params = array(
				// General
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Source', 'total-theme-core' ),
					'param_name' => 'source',
					'value' => [
						esc_html__( 'Manual Input', 'total-theme-core' ) => '',
						esc_html__( 'Custom Field', 'total-theme-core' ) => 'custom_field',
					],
					'admin_label' => true,
				),
				array(
					'type' => 'vcex_custom_field',
					'choices' => 'date',
					'heading' => esc_html__( 'Custom Field ID', 'total-theme-core' ),
					'param_name' => 'custom_field',
					'admin_label' => true,
					'dependency' => array( 'element' => 'source', 'value' => 'custom_field' ),
				),
				array(
					'type' => 'vcex_timezones',
					'heading' => esc_html__( 'Time Zone', 'total' ),
					'param_name' => 'timezone',
					'description' => esc_html__( 'If a time zone is not selected the time zone will be based on the visitors computer time.', 'total' ),
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'End Month', 'total' ),
					'param_name' => 'end_month',
					'value' => array( '1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12' ),
					'admin_label' => true,
					'dependency' => array( 'element' => 'source', 'is_empty' => true ),
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'End Day', 'total' ),
					'param_name' => 'end_day',
					'value' => array( '1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '20', '21', '22', '23', '24', '25', '26', '27', '28', '29', '30', '31' ),
					'admin_label' => true,
					'dependency' => array( 'element' => 'source', 'is_empty' => true ),
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'End Year', 'total' ),
					'param_name' => 'end_year',
					'admin_label' => true,
					'dependency' => array( 'element' => 'source', 'is_empty' => true ),
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'End Time', 'total' ),
					'param_name' => 'end_time',
					'description' => esc_html__( 'Enter your custom end time in military format. Example if your event starts at 1:30pm enter 13:30', 'total' ),
					'dependency' => array( 'element' => 'source', 'is_empty' => true ),
				),
				array(
					'type' => 'vcex_select',
					'heading' => esc_html__( 'Visibility', 'total' ),
					'param_name' => 'visibility',
				),
				array(
					'type' => 'textfield',
					'admin_label' => true,
					'heading' => esc_html__( 'Extra class name', 'total' ),
					'description' => vcex_shortcode_param_description( 'el_class' ),
					'param_name' => 'el_class',
				),
				vcex_vc_map_add_css_animation(),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Animation Duration', 'total'),
					'param_name' => 'animation_duration',
					'css' => true,
					'description' => esc_html__( 'Enter your custom time in seconds (decimals allowed).', 'total'),
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Animation Delay', 'total'),
					'param_name' => 'animation_delay',
					'css' => true,
					'description' => esc_html__( 'Enter your custom time in seconds (decimals allowed).', 'total'),
				),
				// Style
				array(
					'type' => 'vcex_select',
					'heading' => esc_html__( 'Design', 'total' ),
					'param_name' => 'style',
					'choices' => [
						'inline'  => esc_html__( 'Inline', 'total' ),
						'outline' => esc_html__( 'Outline', 'total' ),
						'boxed'   => esc_html__( 'Boxed', 'total' ),
					],
					'group' => esc_html__( 'Style', 'total' ),
				),
				array(
					'type' => 'checkbox',
					'heading' => esc_html__( 'Items', 'total-theme-core' ),
					'param_name' => 'items',
					'std' => 'days,hours,minutes,seconds',
					'value' => array(
						esc_html__( 'Days', 'total-theme-core' ) => 'days',
						esc_html__( 'Hours', 'total-theme-core' ) => 'hours',
						esc_html__( 'Minutes', 'total-theme-core' ) => 'minutes',
						esc_html__( 'Seconds', 'total-theme-core' ) => 'seconds',
					),
					'group' => esc_html__( 'Style', 'total' ),
				),
				array(
					'type' => 'vcex_ofswitch',
					'std' => 'false',
					'param_name' => 'labels_inline',
					'heading' => esc_html__( 'Labels Next to Numbers', 'total-theme-core' ),
					'dependency' => array( 'element' => 'style', 'value' => [ 'outline', 'boxed' ] ),
					'group' => esc_html__( 'Style', 'total' ),
				),
				array(
					'type' => 'vcex_subheading',
					'param_name' => 'vcex_subheading__items_style',
					'text' => esc_html__( 'Main Style', 'total-theme-core' ),
					'group' => esc_html__( 'Style', 'total' ),
				),
				array(
					'type' => 'vcex_select',
					'heading' => esc_html__( 'Bottom Margin', 'total-theme-core' ),
					'param_name' => 'bottom_margin',
					'admin_label' => true,
					'group' => esc_html__( 'Style', 'total' ),
				),
				array(
					'type' => 'vcex_colorpicker',
					'heading' => esc_html__( 'Background Color', 'total' ),
					'param_name' => 'background_color',
					'css' => true,
					'group' => esc_html__( 'Style', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_select',
					'heading' => esc_html__( 'Padding', 'total-theme-core' ),
					'param_name' => 'padding_all',
					'group' => esc_html__( 'Style', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_select',
					'heading' => esc_html__( 'Shadow', 'total' ),
					'param_name' => 'shadow',
					'group' => esc_html__( 'Style', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_select',
					'heading' => esc_html__( 'Border Radius', 'total' ),
					'param_name' => 'border_radius',
					'group' => esc_html__( 'Style', 'total' ),
				),
				array(
					'type' => 'vcex_select',
					'heading' => esc_html__( 'Border Style', 'total-theme-core' ),
					'param_name' => 'border_style',
					'group' => esc_html__( 'Style', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_select',
					'heading' => esc_html__( 'Border Width', 'total' ),
					'param_name' => 'border_width',
					'group' => esc_html__( 'Style', 'total' ),
				),
				array(
					'type' => 'vcex_colorpicker',
					'heading' => esc_html__( 'Border Color', 'total' ),
					'param_name' => 'border_color',
					'css' => true,
					'group' => esc_html__( 'Style', 'total' ),
				),
				// Items Style.
				array(
					'type' => 'vcex_subheading',
					'param_name' => 'vcex_subheading__items_style',
					'text' => esc_html__( 'Items Style', 'total-theme-core' ),
					'dependency' => array( 'element' => 'style', 'value' => [ 'outline', 'boxed' ] ),
					'group' => esc_html__( 'Style', 'total' ),
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Stack Items Breakpoint', 'total-theme-core' ),
					'param_name' => 'stack_breakpoint',
					'value' => vcex_breakpoint_choices(),
					'dependency' => array( 'element' => 'style', 'value' => [ 'outline', 'boxed' ] ),
					'group' => esc_html__( 'Style', 'total' ),
				),
				array(
					'type' => 'vcex_ofswitch',
					'std' => 'false',
					'heading' => esc_html__( 'Stretch Items Horizontally', 'total' ),
					'param_name' => 'stretch_items',
					'dependency' => array( 'element' => 'style', 'value' => [ 'outline', 'boxed' ] ),
					'group' => esc_html__( 'Style', 'total' ),
				),
				array(
					'type' => 'vcex_colorpicker',
					'heading' => esc_html__( 'Background', 'total' ),
					'param_name' => 'item_background',
					'css' => [
						'selector' => '.vcex-countdown__item',
						'property' => 'background-color',
					],
					'dependency' => array( 'element' => 'style', 'value' => [ 'outline', 'boxed' ] ),
					'group' => esc_html__( 'Style', 'total' ),
				),
				array(
					'type' => 'vcex_select',
					'heading' => esc_html__( 'Shadow', 'total' ),
					'param_name' => 'item_shadow',
					'choices' => 'shadow',
					'dependency' => array( 'element' => 'style', 'value' => [ 'outline', 'boxed' ] ),
					'group' => esc_html__( 'Style', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_colorpicker',
					'heading' => esc_html__( 'Border Color', 'total' ),
					'param_name' => 'item_border_color',
					'css' => [
						'selector' => '.vcex-countdown__item',
						'property' => 'border-color',
					],
					'dependency' => array( 'element' => 'style', 'value' => [ 'outline' ] ),
					'group' => esc_html__( 'Style', 'total' ),
				),
				array(
					'type' => 'vcex_select',
					'heading' => esc_html__( 'Border Width', 'total' ),
					'param_name' => 'item_border_width',
					'choices' => 'border_width',
					'css' => [
						'selector' => '.vcex-countdown__item',
						'property' => 'border-width',
					],
					'dependency' => array( 'element' => 'style', 'value' => [ 'outline' ] ),
					'group' => esc_html__( 'Style', 'total' ),
				),
				array(
					'type' => 'vcex_trbl',
					'heading' => esc_html__( 'Padding', 'total' ),
					'param_name' => 'item_padding',
					'css' => [
						'selector' => '.vcex-countdown__item',
						'property' => 'padding',
					],
					'description' => vcex_shortcode_param_description( 'padding' ),
					'dependency' => array( 'element' => 'style', 'value' => [ 'outline', 'boxed' ] ),
					'group' => esc_html__( 'Style', 'total' ),
				),
				array(
					'type' => 'vcex_text',
					'heading' => esc_html__( 'Width', 'total' ),
					'param_name' => 'item_width',
					'css' => [
						'selector' => '.vcex-countdown__item',
						'property' => 'width',
					],
					'description' => vcex_shortcode_param_description( 'px' ),
					'dependency' => array( 'element' => 'style', 'value' => [ 'outline', 'boxed' ] ),
					'group' => esc_html__( 'Style', 'total' ),
				),
				// Typography
				array(
					'type' => 'vcex_text_alignments',
					'heading' => esc_html__( 'Text Align', 'total' ),
					'param_name' => 'text_align',
					'css' => true,
					'group' => esc_html__( 'Typography', 'total' ),
				),
				array(
					'type' => 'vcex_colorpicker',
					'heading' => esc_html__( 'Color', 'total' ),
					'param_name' => 'color',
					'css' => true,
					'group' => esc_html__( 'Typography', 'total' ),
				),
				array(
					'type' => 'vcex_font_size',
					'heading' => esc_html__( 'Font Size', 'total' ),
					'param_name' => 'font_size',
					'css' => true,
					'group' => esc_html__( 'Typography', 'total' ),
				),
				array(
					'type' => 'vcex_font_family_select',
					'heading' => esc_html__( 'Font Family', 'total' ),
					'param_name' => 'font_family',
					'css' => true,
					'group' => esc_html__( 'Typography', 'total' ),
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Font Style', 'total' ),
					'param_name' => 'italic',
					'css' => true,
					'group' => esc_html__( 'Typography', 'total' ),
					'value' => array(
						esc_html__( 'Normal', 'total' ) => '',
						esc_html__( 'Italic', 'total' ) => 'true',
					),
				),
				array(
					'type' => 'vcex_select',
					'heading' => esc_html__( 'Font Weight', 'total' ),
					'param_name' => 'font_weight',
					'css' => true,
					'group' => esc_html__( 'Typography', 'total' ),
				),
				array(
					'type' => 'vcex_preset_textfield',
					'heading' => esc_html__( 'Line Height', 'total' ),
					'param_name' => 'line_height',
					'choices' => 'line_height',
					'css' => true,
					'group' => esc_html__( 'Typography', 'total' ),
				),
				array(
					'type' => 'vcex_preset_textfield',
					'heading' => esc_html__( 'Letter Spacing', 'total' ),
					'param_name' => 'letter_spacing',
					'css' => true,
					'choices' => 'letter_spacing',
					'group' => esc_html__( 'Typography', 'total' ),
				),
				// Labels.
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Days', 'total' ),
					'param_name' => 'days',
					'group' =>  esc_html__( 'Labels', 'total' ),
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Hours', 'total' ),
					'param_name' => 'hours',
					'group' =>  esc_html__( 'Labels', 'total' ),
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Minutes', 'total' ),
					'param_name' => 'minutes',
					'group' =>  esc_html__( 'Labels', 'total' ),
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Seconds', 'total' ),
					'param_name' => 'seconds',
					'group' =>  esc_html__( 'Labels', 'total' ),
				),
				array(
					'type' => 'vcex_font_size',
					'heading' => esc_html__( 'Font Size', 'total' ),
					'param_name' => 'label_font_size',
					'css' => [
						'selector' => '.vcex-countdown__label',
						'property' => 'font-size',
					],
					'group' => esc_html__( 'Labels', 'total' ),
				),
				array(
					'type' => 'vcex_select',
					'std' => 'false',
					'heading' => esc_html__( 'Font Style', 'total' ),
					'param_name' => 'label_italic',
					'choices' => 'font_style',
					'css' => [
						'selector' => '.vcex-countdown__label',
						'property' => 'font_style',
					],
					'group' => esc_html__( 'Labels', 'total' ),
				),
				array(
					'type' => 'vcex_select',
					'heading' => esc_html__( 'Font Weight', 'total' ),
					'param_name' => 'label_font_weight',
					'choices' => 'font_weight',
					'css' => [
						'selector' => '.vcex-countdown__label',
						'property' => 'font-weight',
					],
					'group' => esc_html__( 'Labels', 'total' ),
				),
				// CSS
				array(
					'type' => 'css_editor',
					'heading' => esc_html__( 'CSS box', 'total' ),
					'param_name' => 'css',
					'group' => esc_html__( 'CSS', 'total' ),
				),
			);

			return (array) apply_filters( 'vcex_shortcode_params', $params, self::TAG );
		}

	}

}
new VCEX_Countdown_Shortcode;

if ( class_exists( 'WPBakeryShortCode' ) && ! class_exists( 'WPBakeryShortCode_Vcex_Countdown' ) ) {
	class WPBakeryShortCode_Vcex_Countdown extends WPBakeryShortCode {}
}