<?php
defined( 'ABSPATH' ) || exit;

/**
 * Alert Shortcode.
 *
 * @package TotalThemeCore
 * @version 1.4.6
 */
if ( ! class_exists( 'Vcex_Alert_Shortcode' ) ) {

	class Vcex_Alert_Shortcode {

		/**
		 * Shortcode tag.
		 */
		const TAG = 'vcex_alert';

		/**
		 * Main constructor.
		 */
		public function __construct() {
			add_shortcode( self::TAG, [ __CLASS__, 'output' ] );

			if ( function_exists( 'vc_lean_map' ) ) {
				new \TotalThemeCore\Vcex\WPBakery\Map\Alert;
			}
		}

		/**
		 * Shortcode title.
		 */
		public static function get_title() {
			return esc_html__( 'Alert', 'total-theme-core' );
		}

		/**
		 * Shortcode output => Get template file and display shortcode.
		 */
		public static function output( $atts, $content = null ) {
			if ( ! vcex_maybe_display_shortcode( self::TAG, $atts ) ) {
				return;
			}
			ob_start();
			do_action( 'vcex_shortcode_before', self::TAG, $atts );
			include vcex_get_shortcode_template( self::TAG );
			do_action( 'vcex_shortcode_after', self::TAG, $atts );
			return ob_get_clean();
		}

		/**
		 * Array of shortcode parameters.
		 */
		public static function get_params() {
			$params = array(
				array(
					'type' => 'vcex_select_buttons',
					'heading' => esc_html__( 'Type', 'total-theme-core' ),
					'param_name' => 'type',
					'choices' => array(
						''        => esc_html__( 'Default', 'total-theme-core' ),
						'info'    => esc_html__( 'Info', 'total-theme-core' ),
						'success' => esc_html__( 'Success', 'total-theme-core' ),
						'warning' => esc_html__( 'Warning', 'total-theme-core' ),
						'error'   => esc_html__( 'Error', 'total-theme-core' ),
					),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Heading', 'total' ),
					'param_name' => 'heading',
					'description' => vcex_shortcode_param_description( 'text' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'textarea_html',
					'heading' => esc_html__( 'Content', 'total-theme-core' ),
					'param_name' => 'content',
					'value' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce laoreet vestibulum elit eget fringilla.',
					'admin_label' => true,
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'vcex_select',
					'heading' => esc_html__( 'Visibility', 'total-theme-core' ),
					'param_name' => 'visibility',
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Extra class name', 'total-theme-core' ),
					'param_name' => 'el_class',
					'description' => vcex_shortcode_param_description( 'el_class' ),
					'editors' => [ 'wpbakery', 'elementor' ],
				),
				vcex_vc_map_add_css_animation(),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Animation Duration', 'total'),
					'param_name' => 'animation_duration',
					'description' => esc_html__( 'Enter your custom time in seconds (decimals allowed).', 'total'),
					'editors' => [ 'wpbakery' ],
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Animation Delay', 'total'),
					'param_name' => 'animation_delay',
					'description' => esc_html__( 'Enter your custom time in seconds (decimals allowed).', 'total'),
					'editors' => [ 'wpbakery' ],
				),
				// Style
				array(
					'type' => 'vcex_select',
					'heading' => esc_html__( 'Bottom Margin', 'total-theme-core' ),
					'param_name' => 'bottom_margin',
					'admin_label' => true,
					'group' => esc_html__( 'Style', 'total-theme-core' ),
					'editors' => [ 'wpbakery' ],
				),
				array(
					'type' => 'vcex_select',
					'heading' => esc_html__( 'Vertical Padding', 'total-theme-core' ),
					'param_name' => 'padding_y',
					'group' => esc_html__( 'Style', 'total-theme-core' ),
					'editors' => [ 'wpbakery' ],
				),
				array(
					'type' => 'vcex_select',
					'heading' => esc_html__( 'Shadow', 'total' ),
					'param_name' => 'shadow',
					'group' => esc_html__( 'Style', 'total-theme-core' ),
					'editors' => [ 'wpbakery' ],
				),
				array(
					'type' => 'vcex_select',
					'heading' => esc_html__( 'Font Size', 'total' ),
					'param_name' => 'font_size',
					'group' => esc_html__( 'Style', 'total-theme-core' ),
					'editors' => [ 'wpbakery' ],
				),
			);

			/**
			 * Filters the vcex_alert element params.
			 *
			 * @param array $params
			 */
			$params = (array) apply_filters( 'vcex_shortcode_params', $params, self::TAG );

			return $params;
		}

	}

}
new Vcex_Alert_Shortcode;

if ( class_exists( 'WPBakeryShortCode' ) && ! class_exists( 'WPBakeryShortCode_Vcex_Alert' ) ) {
	class WPBakeryShortCode_Vcex_Alert extends WPBakeryShortCode {}
}