<?php
namespace TotalThemeCore\Vcex;

defined( 'ABSPATH' ) || exit;

/**
 * VCEX Shortcodes.
 *
 * The original Visual Composer Extension Plugin by WPExplorer rebuilt for Total.
 *
 * @package TotalThemeCore
 * @subpackage Vcex
 * @version 1.5.1
 */
final class Init {

	/**
	 * Instance.
	 */
	private static $instance;

	/**
	 * Create or retrieve the instance of Init.
	 */
	public static function instance() {
		if ( is_null( static::$instance ) ) {
			static::$instance = new self();
			static::$instance->global_classes();
			static::$instance->include_functions();
			static::$instance->register_shortcodes();
			static::$instance->gutenberg_support();
			static::$instance->elementor_support();
		}

		return static::$instance;
	}

	/**
	 * Run global classes.
	 */
	private function global_classes() {
		Scripts::instance();
		Ajax::instance();
	}

	/**
	 * Include helper functions.
	 */
	private function include_functions() {
		require_once TTC_PLUGIN_DIR_PATH . 'inc/vcex/functions/deprecated.php';
		require_once TTC_PLUGIN_DIR_PATH . 'inc/vcex/functions/core.php';
		require_once TTC_PLUGIN_DIR_PATH . 'inc/vcex/functions/field-description.php';
		require_once TTC_PLUGIN_DIR_PATH . 'inc/vcex/functions/shortcode-atts.php';
		require_once TTC_PLUGIN_DIR_PATH . 'inc/vcex/functions/arrays.php';
		require_once TTC_PLUGIN_DIR_PATH . 'inc/vcex/functions/sanitize.php';
		require_once TTC_PLUGIN_DIR_PATH . 'inc/vcex/functions/grid-filter.php';
		require_once TTC_PLUGIN_DIR_PATH . 'inc/vcex/functions/loadmore.php';
		require_once TTC_PLUGIN_DIR_PATH . 'inc/vcex/functions/entry-classes.php';
		require_once TTC_PLUGIN_DIR_PATH . 'inc/vcex/functions/font-icons.php';
		require_once TTC_PLUGIN_DIR_PATH . 'inc/vcex/functions/onclick.php';
		require_once TTC_PLUGIN_DIR_PATH . 'inc/vcex/functions/scripts.php';
		require_once TTC_PLUGIN_DIR_PATH . 'inc/vcex/functions/parsers.php';
	}

	/**
	 * Register shortcodes.
	 */
	private function register_shortcodes() {
		Shortcodes_Registry::instance()->register_all();
	}

	/**
	 * Gutenberg support for vcex elements.
	 */
	private function gutenberg_support() {
		if ( apply_filters( 'vcex_gutenberg_integration', true ) ) {
			Gutenberg::instance();
		}
	}

	/**
	 * Elementor support for vcex elements.
	 */
	private function elementor_support() {
		if ( defined( 'WPEX_ELEMENTOR_ACTIVE' ) && WPEX_ELEMENTOR_ACTIVE ) {
			$elementor_support = (bool) apply_filters( 'vcex_elementor_integration', true );
			if ( $elementor_support ) {
				Elementor::instance();
			}
		}
	}

}