<?php
namespace TotalThemeCore\Vcex;

defined( 'ABSPATH' ) || exit;

/**
 * Gutenberg Integration for vcex shortcodes.
 *
 * @package TotalThemeCore
 * @subpackage Vcex
 * @version 1.5.1
 */
class Gutenberg {

	/**
	 * Are custom blocks registered.
	 */
	public static $has_registered_blocks = false;

	/**
	 * Instance.
	 */
	private static $instance;

	/**
	 * Create or retrieve the class instance.
	 */
	public static function instance() {
		if ( is_null( static::$instance ) ) {
			static::$instance = new self();
		}

		return static::$instance;
	}

	public function __construct() {
		add_action( 'init', [ $this, 'register' ] );
	}

	/**
	 * Gutenberg support for vcex elements.
	 */
	public function register() {
		if ( true === self::$has_registered_blocks || ! function_exists( 'register_block_type' ) ) {
			return;
		}

		$this->register_blocks();
		self::$has_registered_blocks = true;

		add_filter( 'block_categories_all', [ $this, 'add_block_category' ] );
	}

	/**
	 * Register blocks.
	 */
	protected function register_blocks() {
		$block_objects = [];

		$blocks = [
			'Button'          => shortcode_exists( 'vcex_button' ),
			'Alert'           => shortcode_exists( 'vcex_alert' ),
			'Divider_Dots'    => shortcode_exists( 'vcex_divider_dots' ),
			'Contact_Form'    => shortcode_exists( 'vcex_contact_form' ),
			'Newsletter_Form' => shortcode_exists( 'vcex_newsletter_form' ),
			'Wpex_Card'       => function_exists( 'wpex_card' ),
			'Widget_Title'    => true,

			//'Post_Meta', // there are core issues with the Query loop CSS.
		];

		foreach ( $blocks as $block => $is_enabled ) {
			if ( $is_enabled ) {
				$block_class = __NAMESPACE__ . '\\Blocks\\' . $block . '\\Block';
				$block_objects[] = new $block_class();
			}
		}

		foreach ( $block_objects as $block_obj ) {
			$block_obj->register_block();
		}
	}

	/**
	 * Gutenberg support for vcex elements.
	 */
	public function add_block_category( $categories ) {
		$category_slugs = wp_list_pluck( $categories, 'slug' );

		if ( ! in_array( 'total', $category_slugs, true ) ) {
		    $categories = array_merge(
		        $categories,
		        [
		            [
		                'title' => 'Total',
		                'slug'  => 'total',
		                'icon'  => '<svg viewBox="0 0 200 200" xmlns="http://www.w3.org/2000/svg"><g clip-rule="evenodd" fill="currentColor" fill-rule="evenodd"><path d="m68.3 21.5 33.7-19.5 42.5 24.5 42.4 24.5v39z"/><path d="m17.2 120.7v-20.7-49l60.3 34.9z"/><path d="m186.9 149-42.4 24.5-42.5 24.5-42.4-24.5-15.8-9.2 84.8-49z"/></g></svg>',
		            ],
		        ]
		    );
		}

		return $categories;
	}

}