/*jshint esversion: 6 */
if ( 'function' !== typeof window.vcexCarousels ) {
	window.vcexCarousels = function( context ) {
		if ( 'undefined' === typeof jQuery || 'function' !== typeof jQuery.fn.wpexOwlCarousel ) {
			return;
		}

		if ( ! context || ! context.childNodes ) {
			context = document;
		}

		let params         = vcex_carousels_params;
		const allCarousels = context.querySelectorAll( '.wpex-carousel' );
		const prevIcon     = params.prevIcon || '<span class="ticon ticon-chevron-left" aria-hidden="true"></span>';
		const nextIcon     = params.nextIcon || '<span class="ticon ticon-chevron-right" aria-hidden="true"></span>';

		if ( ! allCarousels ) {
			return;
		}

		const objectLoop = ( object ) => {
			Object.keys( object ).forEach( key => {
				let val = object[key];
				if ( 'object' == typeof val ) {
					return;
				}
				switch ( val ) {
					case 'false':
						object[key] = false;
						break;
					case 'true':
						object[key] = true;
						break;
					default:
						if ( 'string' === typeof val && ! isNaN( val ) ) {
							object[key] = parseInt( val );
						}
						break;
				}
			} );
		};

		const parseObject = ( object ) => {
			objectLoop( object );
			if ( object.responsive ) {
				Object.keys( object.responsive ).forEach( key => {
					let val = object.responsive[key];
					if ( 'object' === typeof val ) {
						objectLoop( val );
					}
					if ( 'string' === typeof key ) {
						delete Object.assign(object, {[parseInt( key )]: object[key] })[key];
					}
				} );
			}
		//	console.log( object );
			return object;
		};

		const parseData = ( carouselData ) => {
			if ( ! params.navText ) {
				carouselData.navText = [
					'<span class="screen-reader-text">' + params.i18n.next + '</span>' + prevIcon,
					'<span class="screen-reader-text">' + params.i18n.prev + '</span>' + nextIcon
				];
			}
		};

		const renderCarousel = function( carousel ) {
			let carouselData = carousel.dataset.wpexCarousel ? JSON.parse( carousel.dataset.wpexCarousel ) : {};
			parseData( carouselData );
			jQuery( carousel ).wpexOwlCarousel( parseObject( jQuery.extend( true, {}, params, carouselData ) ) );
		};

		allCarousels.forEach( function( element ) {
			if ( 'function' === typeof imagesLoaded ) {
				imagesLoaded( element, function() {
					renderCarousel( element );
				} );
			} else {
				renderCarousel( element );
			}
		} );
	};
}

if ( document.readyState === 'interactive' || document.readyState === 'complete' ) {
	setTimeout( vcexCarousels, 0 );
} else {
	document.addEventListener( 'DOMContentLoaded', vcexCarousels, false );
}