/*jshint esversion: 6 */
if ( 'function' !== typeof window.vcexStickyNavbar ) {
	window.vcexStickyNavbar = function( $context ) {

		// -------------------------- HELPERS -------------------------- //

		/**
		 * Get window scroll position.
		 */
		const winTop = () => {
			var scrollTop = window.pageYOffset || document.documentElement.scrollTop || document.body.scrollTop || 0;
			if ( scrollTop < 0 ) {
				scrollTop = 0; // return 0 if negative to prevent issues with elastic scrolling in Safari.
			}
			return scrollTop;
		};

		/**
		 * Get element offset.
		 */
		const elOffset = ( element ) => {
			const rect = element.getBoundingClientRect();
			return {
				top: rect.top + winTop(),
				left: rect.left + winTop(),
			};
		};

		/**
		 * Returns element height.
		 */
		const elHeight = ( element ) => {
			return element.getBoundingClientRect().height;
		};

		/**
		 * Returns element width.
		 */
		const elWidth = ( element ) => {
			return element.getBoundingClientRect().width;
		};

		/**
		 * Check is element is visible.
		 */
		const isVisible = ( element ) => {
			if ( ! element ) {
				return false;
			}
			return !!( element.offsetWidth || element.offsetHeight || element.getClientRects().length );
		};

		/**
		 * Creates new sticky wrapper around navbar.
		 */
		const addStickyWrapper = ( navbar ) => {
			const wrapper = document.createElement( 'div' );
			wrapper.className = 'vcex-navbar-sticky-wrapper not-sticky';
			if ( navbar.nextSibling ) {
				navbar.parentNode.insertBefore( wrapper, navbar.nextSibling );
			} else {
				navbar.parentNode.appendChild( wrapper );
			}
			wrapper.appendChild( navbar );
			return wrapper;
		};

		// -------------------------- STICKY -------------------------- //

		/**
		 * Loops through sticky navbars.
		 */
		document.querySelectorAll( '.vcex-navbar-sticky' ).forEach( ( navbar ) => {
			let isSticky       = false;
			let stickyEndPoint = navbar.dataset.stickyEndpoint || navbar.dataset.vcexStickyEndpoint || '';

			if ( stickyEndPoint ) {
				stickyEndPoint = document.querySelector( stickyEndPoint );
			}

			// Create sticky wrapper.
			const stickyWrapper = addStickyWrapper( navbar );

			/**
			 * Check sticky offSet based on other sticky elements.
			 */
			function getStickyOffset() {
				let offset  = 0;
				const items = navbar.dataset.vcexStickyOffsetItems || '#top-bar-wrap-sticky-wrapper.wpex-can-sticky #top-bar-wrap,#site-header-sticky-wrapper.wpex-can-sticky #site-header,#site-navigation-sticky-wrapper.wpex-can-sticky #site-navigation-wrap,#wpex-mobile-menu-fixed-top,#wpadminbar,.wpex-sticky-el-offset';
				document.querySelectorAll( items ).forEach( ( item ) => {
					if ( isVisible( item ) && 'fixed' === window.getComputedStyle( item ).position ) {
						// @todo add extra checks for shrink sticky header?
						offset = parseInt( offset ) + elHeight( item );
					}
				} );
				return offset;
			}

			/**
			 * Check if element should stick
			 */
			const stickyCheck = () => {
				const windowTop     = winTop();
				const stickyOffset  = getStickyOffset();
				const stickyWrapTop = elOffset( stickyWrapper ).top;
				const setStickyPos  = stickyWrapTop - stickyOffset;

				if ( windowTop > setStickyPos && 0 !== windowTop ) {
					setSticky( stickyOffset );
					if ( stickyEndPoint && isVisible( stickyEndPoint ) ) {
						if ( windowTop > ( elOffset( stickyEndPoint ).top - stickyOffset - elHeight( navbar ) ) ) {
							stickyWrapper.classList.add( 'sticky-hidden' );
							navbar.style.opacity = '0';
							navbar.style.zIndex  = '-1';
						} else {
							stickyWrapper.classList.remove( 'sticky-hidden' );
							navbar.style.opacity = '';
							navbar.style.zIndex  = '';
						}
					}
				} else {
					destroySticky();
				}
			};

			/**
			 * Sticks navbar.
			 */
			const setSticky = ( offset ) => {
				if ( ! isVisible( navbar ) ) {
					destroySticky();
					return;
				}

				// Already sticky.
				if ( isSticky ) {
					navbar.style.top = getStickyOffset() + 'px'; // fix for shrink sticky items.
					return;
				}

				// Update sticky wrapper.
				stickyWrapper.style.height = elHeight( navbar ) + 'px';
				stickyWrapper.classList.remove( 'not-sticky' );
				stickyWrapper.classList.add( 'is-sticky' );

				// Update navbar.
				navbar.classList.add( 'wpex-z-99' );

				// Position Fixed nav.
				navbar.style.position = 'fixed';
				navbar.style.top      = offset + 'px';
				navbar.style.width    = elWidth( stickyWrapper ) + 'px';

				// Update sticky check.
				isSticky = true;
			};

			/**
			 * Unsticks navbar.
			 */
			 const destroySticky = () => {
				if ( ! isSticky ) {
					return;
				}

				// Remove sticky wrap height and toggle sticky class.
				stickyWrapper.style.height = '';
				stickyWrapper.classList.remove( 'is-sticky' );
				stickyWrapper.classList.add( 'not-sticky' );

				// Tweak navbar classes.
				navbar.classList.remove( 'wpex-z-99' );
				stickyWrapper.classList.remove( 'sticky-hidden' );

				// Update navbar styles.
				navbar.style.position = '';
				navbar.style.top      = '';
				navbar.style.width    = '';
				navbar.style.opacity  = '';
				navbar.style.zIndex   = '';

				// Update sticky check.
				isSticky = false;
			};

			/**
			 * Runs on resize.
			 */
			const onResize = () => {
				stickyCheck();

				// Sticky tweaks.
				if ( isSticky ) {

					if ( ! isVisible( navbar ) ) {
						destroySticky();
					}

					// Update element dimensions and position.
					stickyWrapper.style.height = elHeight( navbar ) + 'px';
					navbar.style.top = getStickyOffset() + 'px';
					navbar.style.width = elWidth( stickyWrapper ) + 'px';

				} else {
				//	stickyCheck();
				}

			};

			const onFlip = () => {
				destroySticky();
				stickyCheck();
			};

			/*** EVENTS ****/

			// Fire on init.
			stickyCheck();

			// Fire onscroll event.
			window.addEventListener( 'scroll', stickyCheck, { passive: true } );

			// Fire onResize.
			window.addEventListener( 'resize', onResize );

			// Fire resize on flip.
			window.addEventListener( 'orientationchange', onFlip );
		} );

	};
}

// -------------------------- GET THINGS STARTED -------------------------- //

window.addEventListener( 'load', () => {
	vcexStickyNavbar();
} );

// -------------------------- INTEGRATIONS -------------------------- //

/**
 * Fix potential width issues with sticky elements inside WPBakery stretched rows in Firefox/Safari.
 * This is because sometimes window.load loads after document.ready
 */
if ( 'function' === typeof jQuery && document.body.classList.contains( 'wpb-js-composer' ) ) {
	jQuery( document ).on( 'vc_js', function() {
		document.querySelectorAll( '[data-vc-full-width-init] .vcex-navbar-sticky' ).forEach( ( element ) => {
			var stickyWrapper = element.closest( '.vcex-navbar-sticky-wrapper' );
			if ( stickyWrapper ) {
				element.style.width = stickyWrapper.getBoundingClientRect().width + 'px';
			}
		} );
	} );
}