if ( 'function' !== typeof window.vcexNavbarMobileSelect ) {
	window.vcexNavbarMobileSelect = function() {
		const allSelects = document.querySelectorAll( '.vcex-navbar-mobile-select select' );

		if ( ! allSelects.length ) {
			return;
		}

		const onPagesShow = ( event ) => {
			if ( true === event.persisted ) {
				allSelects.forEach( ( select ) => {
					select.selectedIndex = 0;
				} );
			}
		};

		const addSelectEvents = ( select ) => {
			const nav = select.closest( '.vcex-navbar' );
			select.addEventListener( 'change', ( event ) => {
				if ( event.target.value ) {
					const targetLink = nav.querySelector( '.vcex-navbar-inner a[href="' + event.target.value + '"]' );
					if ( targetLink ) {
						targetLink.click();
					}
				}
			} );
		};

		// Add events.
		allSelects.forEach( addSelectEvents );
		window.addEventListener( 'pageshow', onPagesShow ); // fixes selected issue when using the back button.
	};
}

if ( document.readyState === 'interactive' || document.readyState === 'complete' ) {
	setTimeout( vcexNavbarMobileSelect, 0 );
} else {
	document.addEventListener( 'DOMContentLoaded', vcexNavbarMobileSelect, false );
}