/*jshint esversion: 6 */
if ( 'function' !== typeof window.vcexNavbarFilterLinks ) {
	window.vcexNavbarFilterLinks = function( context ) {
		if ( 'function' !== typeof Isotope ) {
			return;
		}

		if ( ! context || ! context.childNodes ) {
			context = document;
		}

		const isotopeInit = ( grid, settings ) => {
			const iso = new Isotope( grid, settings );
			if ( 'function' === typeof imagesLoaded ) {
				imagesLoaded( grid ).on( 'progress', function( instance, image ) {
					iso.layout();
				} );
			}
		};

		const initIsotope = ( grid, settings ) => {
			if ( ! grid.classList.contains( 'vcex-navbar-filter-grid' ) ) {
				grid.classList.add( 'vcex-navbar-filter-grid' );
				isotopeInit( grid, settings );
			}
			// Add isotope only, the filter grid already exists - @todo is this needed?
			else {
				isotopeInit( grid, {} );
			}
		};

		const filterGrid = ( grid, filter ) => {
			const iso = Isotope.data( grid );

			if ( ! iso ) {
			//	console.log( grid );
				return;
			}

			iso.arrange( {
				filter: filter
			} );

			/* Hide animated items.
			if ( 'function' === typeof vc_waypoints ) {
				grid.querySelectorAll( '.wpb_animate_when_almost_visible' ).forEach( element => {
					element.classList.remove( 'wpb_start_animation', 'animated', 'wpb-animate-in-sequence' );
					document.dispatchEvent( new Event( 'vc_waypoints_destroy' ) );
					setTimeout(() => {
						vc_waypoints();
					}, 100);
				} );
			}
			*/

			iso.on( 'arrangeComplete', function() {
				// Refesh waypoints.
				if ( 'function' === typeof VcWaypoint ) {
					VcWaypoint.refreshAll();
				}
				if ( 'function' === typeof Waypoint ) {
					Waypoint.refreshAll();
				}
			} );
		};

		// Loops through filter navs to initialize masonry and set default active items.
		const initialize = () => {
			context.querySelectorAll( '.vcex-filter-nav' ).forEach( function( nav ) {
				var settings,
					grid = context.querySelector( '#' + nav.dataset.filterGrid );

				if ( ! grid ) {
					return;
				}

				if ( ! grid.classList.contains( 'wpex-row' ) ) {
					grid = grid.querySelector( '.wpex-row' );
				}

				if ( ! grid ) {
					return;
				}

				if ( grid.dataset.filterGridInit && 'true' === grid.dataset.filterGridInit ) {
					return;
				}

				// Remove isotope class since we are adding our own masonry.
				grid.classList.remove( 'vcex-isotope-grid' );

				// Get settings from data attributes.
				var activeItems    = nav.dataset.filter;
				var customDuration = nav.dataset.transitionDuration;
				var customLayout   = nav.dataset.layoutMode;

				// Define masonry settings.
				if ( 'object' === typeof wpex_isotope_params ) {
					settings = Object.assign( {}, wpex_isotope_params ); // create new object to keep wpex_isotope_params intact.
				} else {
					settings = {
						transformsEnabled: true,
						transitionDuration: '0.4s',
						layoutMode: 'masonry',
					};
				}

				if ( document.body.classList.contains( 'rtl' ) ) {
					settings.isOriginLeft = false;
				}

				if ( 'undefined' !== typeof customDuration ) {
					settings.transitionDuration = parseFloat( customDuration ) + 's';
				}

				/*if ( grid.querySelector( '.wpb_animate_when_almost_visible' ) ) {
					settings.transitionDuration = 0;
				}*/

				if ( 'undefined' !== typeof customLayout ) {
					settings.layoutMode = customLayout;
				}

				if ( activeItems && nav.querySelector( '[data-filter="' + activeItems + '"]' ) ) {
					settings.filter = activeItems;
				}

				settings.itemSelector = '.col'; // because the vcex-isotope-entry can't be added.

				if ( grid.closest( '[data-vc-stretch-content]' ) ) {
					setTimeout( function() {
						initIsotope( grid, settings );
					}, 10 );
				} else {
					initIsotope( grid, settings );
				}

				grid.setAttribute( 'data-filter-grid-init', 'true' );
			} );
		}

		// Filters grid when clicking on filter links.
		const onClick = ( event ) => {
			var filterLink = event.target.closest( '.vcex-navbar-link' );
			if ( ! filterLink ) {
				return;
			}

			var nav = filterLink.closest( '.vcex-filter-nav' );

			if ( ! nav ) {
				return;
			}

			var grid = context.querySelector( '#' + nav.dataset.filterGrid );

			if ( ! grid ) {
				return;
			}

			if ( ! grid.classList.contains( 'wpex-row' ) ) {
				grid = grid.querySelector( '.wpex-row' );
			}

			if ( ! grid ) {
				return;
			}

			var filter = filterLink.dataset.filter || '*';

			nav.querySelectorAll( '.vcex-navbar-link' ).forEach( function( element ) {
				element.classList.remove( 'active' );
			} );

			filterLink.classList.add( 'active' );

			filterGrid( grid, filter );

			event.preventDefault();
			event.stopPropagation();
		};

		// -------------------------- ATTACH EVENTS -------------------------- //
		initialize();
		document.addEventListener( 'click', onClick );
	};

}

if ( document.readyState === 'interactive' || document.readyState === 'complete' ) {
	setTimeout( vcexNavbarFilterLinks, 0 );
} else {
	document.addEventListener( 'DOMContentLoaded', vcexNavbarFilterLinks, false );
}