if ( 'function' !== typeof window.vcexCountDown ) {
	window.vcexCountDown = function( context ) {
		if ( 'undefined' === typeof jQuery || 'function' !== typeof jQuery.fn.countdown ) {
			return;
		}

		if ( ! context || ! context.childNodes ) {
			context = document;
		}

		context.querySelectorAll( '.vcex-countdown' ).forEach( function( element ) {
			let endDate = element.dataset.countdown;
			const days = element.dataset.days;
			const hours = element.dataset.hours;
			const minutes = element.dataset.minutes;
			const seconds = element.dataset.seconds;
			const timezone = element.dataset.timezone;
			let itemClass = element.dataset.itemClass || '';

			if ( timezone && 'function' === typeof moment.tz ) {
				endDate = moment.tz( endDate, timezone ).toDate();
			}

			if ( ! endDate ) {
				return;
			}

			if ( itemClass && 'undefined' !== itemClass ) {
				element.removeAttribute( 'data-item-class' );
				itemClass = ' ' + itemClass;
			} else {
				itemClass = ' wpex-inline-block';
			}

			let stringItems = [];

			if ( days ) {
				stringItems.push( `<div class="vcex-countdown__item vcex-countdown__item--days wpex-days${itemClass}"><span class="vcex-countdown__number">%-D</span> <small class="vcex-countdown__label">${days}</small></div>` );
			}

			if ( hours ) {
				stringItems.push( `<div class="vcex-countdown__item vcex-countdown__item--hours wpex-hours${itemClass}"><span class="vcex-countdown__number">%-H</span> <small class="vcex-countdown__label">${hours}</small></div>` );
			}

			if ( minutes ) {
				stringItems.push( `<div class="vcex-countdown__item vcex-countdown__item--minutes wpex-minutes${itemClass}"><span class="vcex-countdown__number">%-M</span> <small class="vcex-countdown__label">${minutes}</small></div>` );
			}

			if ( seconds ) {
				stringItems.push( `<div class="vcex-countdown__item vcex-countdown__item--seconds wpex-seconds${itemClass}"><span>%-S</span class="vcex-countdown__number"> <small class="vcex-countdown__label">${seconds}</small></div>` );
			}

			jQuery( element ).countdown( endDate, function( event ) {
				jQuery( this ).html( event.strftime( stringItems.join( ' ' ) ) );
			} );

		} );
	};

}

if ( document.readyState === 'interactive' || document.readyState === 'complete' ) {
	setTimeout( vcexCountDown, 0 );
} else {
	document.addEventListener( 'DOMContentLoaded', vcexCountDown, false );
}