<?php
namespace TotalThemeCore\Vcex\Acf;

defined( 'ABSPATH' ) || exit;

/**
 * ACF Helpers
 *
 * @package TotalThemeCore
 * @version 1.5
 */

class Utils {

	/**
	 * Instance.
	 */
	private static $instance;

	/**
	 * Create or retrieve the class instance.
	 */
	public static function instance() {
		if ( is_null( static::$instance ) ) {
			static::$instance = new self();
		}

		return static::$instance;
	}

	/**
	 * Returns image ID from acf field.
	 */
	public static function get_field_image_id( $field_key = '', $post_id = false ) {
		if ( ! function_exists( 'get_field' ) ) {
			return;
		}

		$val = get_field( $field_key, $post_id );

		if ( is_numeric( $val ) ) {
			return $val;
		}

		if ( is_array( $val ) ) {
			return $val['ID'] ?? $val['id'] ?? null;
		} else if ( is_string( $val ) ) {
			return attachment_url_to_postid( $val );
		}

	}

}