<?php
namespace TotalThemeCore;

defined( 'ABSPATH' ) || exit;

final class Register_Scripts {

	/**
	 * Instance.
	 */
	private static $instance;

	/**
	 * Create or retrieve the instance of Register_Scripts.
	 */
	public static function instance() {
		if ( is_null( static::$instance ) ) {
			static::$instance = new self();
			static::$instance->init_hooks();
		}

		return static::$instance;
	}

	/**
	 * Get things started.
	 */
	public function init_hooks() {
		add_action( 'admin_enqueue_scripts', [ $this, 'admin' ] );
	}

	/**
	 * Register admin scripts.
	 */
	public function admin() {
		wp_register_script(
			'wp-color-picker-alpha',
			TTC_PLUGIN_DIR_URL . 'assets/js/wp-color-picker-alpha.min.js',
			[ 'wp-color-picker', 'jquery' ],
			'3.0.2',
			true
		);
	}

}